package com.rocogz.syy.operation.entity.quotapply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 发放主体 额度申请审批流设置,流程定义
 * </p>
 *
 * @author zhangmin
 * @since 2021-06-23
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OperateQuotaIssuingConfigNode extends BaseQuotaNode {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 流程定义版本
     */
    private Integer version;


    //暂时保留这3个字段，方便历史数据迁移，上线后下个版本删除该字段
    @Deprecated
    private String approverUser;
    private String approverName;
    private String approverMobile;


    private String createUser;

    private LocalDateTime createTime;

    private String updateUser;

    private LocalDateTime updateTime;


    //该节点审批人信息
    @TableField(exist = false)
    private List<OperateQuotaConfigNodeApprover> approverList;


    //平台/服务商节点 总的配置审批人数据集合
    @TableField(exist = false)
    private List<OperateQuotaConfigNodeApprover> totalApproverList;

}
