package com.rocogz.syy.settlement.entity.invoicematter;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 新增开票事项实体类
 * @date：2021/9/8
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("settle_invoice_matter")
public class SettleInvoiceMatter extends IdEntity {

    private static final long serialVersionUID = 477447239518274241L;

    /**
    * 编码
    */
    private String code;
    
    /**
    * 服务商编号
    */
    private String agentCode;
    
    /**
    * 发放主体编号
    */
    private String issuingBodyCode;
    
    /**
    * 结算主体编号
    */
    private String settleSubjectCode;
    
    /**
    * 业务归属年份
    */
    private String businessYear;
    
    /**
    * 业务归属月份
    */
    private String businessMonth;
    
    /**
    * 开票事项备注
    */
    private String matterRemark;
    
    /**
    * 发票代码
    */
    private String invoiceCode;
    
    /**
    * 发票号码
    */
    private String invoiceNo;
    
    /**
    * 付款方
    */
    private String payer;
    
    /**
    * 收款方
    */
    private String payee;
    
    /**
    * 发票类型
    */
    private String invoiceType;
    
    /**
    * 发票税率
    */
    private BigDecimal invoiceTaxRate;
    
    /**
    * 发票金额
    */
    private BigDecimal invoiceAmount;
    
    /**
    * 发票税额
    */
    private BigDecimal invoiceTaxAmount;
    
    /**
    * 发票含税金额
    */
    private BigDecimal invoiceIncludeTaxAmount;
    
    /**
    * 开票时间
    */
    private LocalDate invoicingTime;
    
    /**
    * 发票图片
    */
    private String invoiceImagePath;
    
    /**
    * 发票说明
    */
    private String invoiceRemark;
    
    /**
    * 送达方式
    */
    private String deliveryWay;
    
    /**
    * 快递单号
    */
    private String courierNo;
    
    /**
    * 快递公司
    */
    private String courierCompany;
    
    /**
    * 快递发出日期
    */
    private LocalDate courierSendTime;
    
    /**
    * 快递送达日期
    */
    private LocalDate courierReceiveTime;
    
    /**
    * 送票人姓名
    */
    private String distributor;
    
    /**
    * 送票人手机号
    */
    private String distributorMobile;
    
    /**
    * 接收人姓名
    */
    private String receiver;
    
    /**
    * 接收人手机号
    */
    private String receiverMobile;
    
    /**
    * 快递单截图
    */
    private String courierImagePath;
    
    /**
    * 送达凭证
    */
    private String deliveryImagePath;
    
    /**
    * 寄送备注
    */
    private String deliveryRemark;
    
    /**
    * 作废日期
    */
    private LocalDate toVoidTime;
    
    /**
    * 作废备注
    */
    private String toVoidRemark;
    
    /**
    * 事项状态（字典类型：AGENT_INVOICE_MATTER_STATUS）
    */
    private String status;
    
    /**
    * 收款单号
    */
    private String receiptCode;
    
    /**
    * 收款到账日期
    */
    private LocalDate receiptTime;
    
    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 更新人
    */
    private String updateUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
}