package com.rocogz.syy.settlement.entity.invoicematter;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 服务商开票事项附件实体类
 * @date：2021/9/8
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("settle_invoice_matter_attach")
public class SettleInvoiceMatterAttach extends IdEntity {

    private static final long serialVersionUID = 503627314120017684L;

    /**
    * 开票事项编码
    */
    private String invoiceMatterCode;
    
    /**
    * 附件类型：MATTER-事项附件，TO_VOID-作废附件
    */
    private String type;
    
    /**
    * 文件名称
    */
    private String fileName;
    
    /**
    * 文件路径
    */
    private String filePath;
    
    /**
    * 文件说明
    */
    private String fileRemark;
    
    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 更新人
    */
    private String updateUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
}