package com.rocogz.syy.weixin.pay.config;

import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * <dl>
 * <dd>Description: WxPayServiceHolder</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/9/3 9:18</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Getter
@Setter
public class WxPayServiceHolder {

    /**
     * 默认的收款商户.
     */
    private WxPayConfig defaultMch;

    /**
     * wxPayConfigMap。
     */
    private final Map<String, WxPayConfig> wxPayConfigMap = new HashMap<>();

    /**
     * wxPayServiceMap。
     */
    private final Map<String, WxPayService> wxPayServiceMap = new HashMap<>();

    /**
     * 默认的退款回调地址Map.
     */
    private final Map<String, String> defaultRefundNotifyUrlMap = new HashMap<>();
}
