/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.utils;

import com.alibaba.nacos.client.config.impl.HttpSimpleClient;
import com.alibaba.nacos.client.utils.AppNameUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.StringUtils;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.client.utils.TenantUtil;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class ParamUtil {
    private static final Logger LOGGER = LogUtils.logger(ParamUtil.class);
    public static final boolean USE_ENDPOINT_PARSING_RULE_DEFAULT_VALUE = true;
    private static final Pattern PATTERN = Pattern.compile("\\$\\{[^}]+\\}");
    private static String defaultContextPath;
    private static String defaultNodesPath;
    private static String appKey;
    private static String appName;
    private static String defaultServerPort;
    private static String clientVersion;
    private static int connectTimeout;
    private static double perTaskConfigSize;

    public static String getAppKey() {
        return appKey;
    }

    public static void setAppKey(String appKey) {
        ParamUtil.appKey = appKey;
    }

    public static String getAppName() {
        return appName;
    }

    public static void setAppName(String appName) {
        ParamUtil.appName = appName;
    }

    public static String getDefaultContextPath() {
        return defaultContextPath;
    }

    public static void setDefaultContextPath(String defaultContextPath) {
        ParamUtil.defaultContextPath = defaultContextPath;
    }

    public static String getClientVersion() {
        return clientVersion;
    }

    public static void setClientVersion(String clientVersion) {
        ParamUtil.clientVersion = clientVersion;
    }

    public static int getConnectTimeout() {
        return connectTimeout;
    }

    public static void setConnectTimeout(int connectTimeout) {
        ParamUtil.connectTimeout = connectTimeout;
    }

    public static double getPerTaskConfigSize() {
        return perTaskConfigSize;
    }

    public static void setPerTaskConfigSize(double perTaskConfigSize) {
        ParamUtil.perTaskConfigSize = perTaskConfigSize;
    }

    public static String getDefaultServerPort() {
        return defaultServerPort;
    }

    public static String getDefaultNodesPath() {
        return defaultNodesPath;
    }

    public static void setDefaultNodesPath(String defaultNodesPath) {
        ParamUtil.defaultNodesPath = defaultNodesPath;
    }

    public static String parseNamespace(Properties properties) {
        String namespaceTmp = null;
        String isUseCloudNamespaceParsing = properties.getProperty("isUseCloudNamespaceParsing", System.getProperty("nacos.use.cloud.namespace.parsing", String.valueOf(true)));
        if (Boolean.parseBoolean(isUseCloudNamespaceParsing)) {
            namespaceTmp = TemplateUtils.stringBlankAndThenExecute(namespaceTmp, new Callable<String>(){

                @Override
                public String call() {
                    return TenantUtil.getUserTenantForAcm();
                }
            });
            namespaceTmp = TemplateUtils.stringBlankAndThenExecute(namespaceTmp, new Callable<String>(){

                @Override
                public String call() {
                    String namespace = System.getenv("ALIBABA_ALIWARE_NAMESPACE");
                    return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)namespace) ? namespace : "";
                }
            });
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(namespaceTmp)) {
            namespaceTmp = properties.getProperty("namespace");
        }
        return StringUtils.isNotBlank(namespaceTmp) ? namespaceTmp.trim() : "";
    }

    public static String parsingEndpointRule(String endpointUrl) {
        String endpointUrlSource;
        if (endpointUrl == null || !PATTERN.matcher(endpointUrl).find()) {
            String endpointUrlSource2 = System.getenv("ALIBABA_ALIWARE_ENDPOINT_URL");
            if (StringUtils.isNotBlank(endpointUrlSource2)) {
                endpointUrl = endpointUrlSource2;
            }
            return StringUtils.isNotBlank(endpointUrl) ? endpointUrl : "";
        }
        endpointUrl = endpointUrl.substring(endpointUrl.indexOf("${") + 2, endpointUrl.lastIndexOf("}"));
        int defStartOf = endpointUrl.indexOf(":");
        String defaultEndpointUrl = null;
        if (defStartOf != -1) {
            defaultEndpointUrl = endpointUrl.substring(defStartOf + 1);
            endpointUrl = endpointUrl.substring(0, defStartOf);
        }
        if (StringUtils.isBlank(endpointUrlSource = TemplateUtils.stringBlankAndThenExecute(System.getProperty(endpointUrl, System.getenv(endpointUrl)), new Callable<String>(){

            @Override
            public String call() {
                return System.getenv("ALIBABA_ALIWARE_ENDPOINT_URL");
            }
        }))) {
            if (StringUtils.isNotBlank(defaultEndpointUrl)) {
                endpointUrl = defaultEndpointUrl;
            }
        } else {
            endpointUrl = endpointUrlSource;
        }
        return StringUtils.isNotBlank(endpointUrl) ? endpointUrl : "";
    }

    static {
        defaultNodesPath = "serverlist";
        clientVersion = "unknown";
        perTaskConfigSize = 3000.0;
        appKey = System.getProperty("nacos.client.appKey", "");
        defaultContextPath = System.getProperty("nacos.client.contextPath", "nacos");
        appName = AppNameUtils.getAppName();
        String defaultServerPortTmp = "8848";
        defaultServerPort = System.getProperty("nacos.server.port", defaultServerPortTmp);
        LOGGER.info("[settings] [req-serv] nacos-server port:{}", (Object)defaultServerPort);
        String tmp = "1000";
        try {
            tmp = System.getProperty("NACOS.CONNECT.TIMEOUT", "1000");
            connectTimeout = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid connect timeout:" + tmp;
            LOGGER.error("[settings] " + msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
        LOGGER.info("[settings] [http-client] connect timeout:{}", (Object)connectTimeout);
        try {
            InputStream in = HttpSimpleClient.class.getClassLoader().getResourceAsStream("application.properties");
            Properties props = new Properties();
            props.load(in);
            String val = null;
            val = props.getProperty("version");
            if (val != null) {
                clientVersion = val;
            }
            LOGGER.info("NACOS_CLIENT_VERSION: {}", (Object)clientVersion);
        }
        catch (Exception e) {
            LOGGER.error("[500] read application.properties", (Throwable)e);
        }
        try {
            perTaskConfigSize = Double.valueOf(System.getProperty("PER_TASK_CONFIG_SIZE", "3000"));
            LOGGER.info("PER_TASK_CONFIG_SIZE: {}", (Object)perTaskConfigSize);
        }
        catch (Throwable t) {
            LOGGER.error("[PER_TASK_CONFIG_SIZE] PER_TASK_CONFIG_SIZE invalid", t);
        }
    }
}

