/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudecho.qrcode;

import com.github.cloudecho.qrcode.ImageUtil;
import com.github.cloudecho.qrcode.ZxingEntry;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ZxingCode {
    static final int WHITE = -1;
    static final int BLACK = -16777216;

    public void encode(ZxingEntry zxing) throws WriterException, IOException {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, zxing.getErrorCorrectionLevel());
        hints.put(EncodeHintType.CHARACTER_SET, zxing.getCharset());
        hints.put(EncodeHintType.MARGIN, zxing.getMargin());
        BitMatrix bitMatrix = new MultiFormatWriter().encode(zxing.getContent(), BarcodeFormat.QR_CODE, zxing.getWidth(), zxing.getHeight(), hints);
        File dir = new File(zxing.getDir());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ZxingCode.writeToFile(bitMatrix, zxing.getFormat(), new File(zxing.getPath()), zxing.getLogoPath(), zxing.getLogoCornerRadius());
    }

    public Result decode(String path, String charset) throws IOException, NotFoundException {
        Assert.hasText((String)path, (String)"[decode]\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        File file = new File(path);
        BufferedImage image = ImageIO.read(file);
        if (image == null) {
            throw new IOException("Could not decode image: " + path);
        }
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, charset);
        return new MultiFormatReader().decode(bitmap, hints);
    }

    static void writeToFile(BitMatrix bitMatrix, String format, File file, String logoPath, int logoCornerRadius) throws IOException {
        BufferedImage bi = ZxingCode.toBufferedImage(bitMatrix);
        if (StringUtils.hasText((String)logoPath)) {
            int width_4 = bitMatrix.getWidth() / 4;
            int width_8 = width_4 / 2;
            int height_4 = bitMatrix.getHeight() / 4;
            int height_8 = height_4 / 2;
            BufferedImage logoimg = ImageIO.read(new File(logoPath));
            int currentImgWidth = logoimg.getWidth();
            int currentImgHeight = logoimg.getHeight();
            int resultImgWidth = 0;
            int resultImgHeight = 0;
            if (currentImgWidth != width_4) {
                resultImgWidth = width_4;
            }
            if (currentImgHeight != width_4) {
                resultImgHeight = width_4;
            }
            if (logoCornerRadius > 0) {
                logoimg = ImageUtil.makeRoundedCorner(logoimg, logoCornerRadius);
            }
            BufferedImage bi2 = bi.getSubimage(width_4 + width_8, height_4 + height_8, width_4, height_4);
            Graphics2D g2 = bi2.createGraphics();
            g2.drawImage(logoimg.getScaledInstance(resultImgWidth, resultImgHeight, 4), 0, 0, null);
            g2.dispose();
            bi.flush();
        }
        ImageIO.write((RenderedImage)bi, format, file);
    }

    static BufferedImage toBufferedImage(BitMatrix bitMatrix) {
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }
}

