/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.handler.threadpool;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.exception.JobConfigurationException;
import org.apache.shardingsphere.elasticjob.infra.handler.threadpool.JobExecutorServiceHandler;

public final class JobExecutorServiceHandlerFactory {
    private static final Map<String, JobExecutorServiceHandler> HANDLERS = new LinkedHashMap<String, JobExecutorServiceHandler>();
    private static final String DEFAULT_HANDLER = "CPU";

    public static JobExecutorServiceHandler getHandler(String type) {
        if (Strings.isNullOrEmpty((String)type)) {
            return HANDLERS.get(DEFAULT_HANDLER);
        }
        if (!HANDLERS.containsKey(type)) {
            throw new JobConfigurationException("Can not find executor service handler type '%s'.", type);
        }
        return HANDLERS.get(type);
    }

    @Generated
    private JobExecutorServiceHandlerFactory() {
    }

    static {
        for (JobExecutorServiceHandler each : ServiceLoader.load(JobExecutorServiceHandler.class)) {
            HANDLERS.put(each.getType(), each);
        }
    }
}

