/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinatorRegistry;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudCoordinator;
import org.bytesoft.bytetcc.supports.springcloud.loadbalancer.CompensableLoadBalancerInterceptor;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.web.client.RestTemplate;

public final class SpringCloudBeanRegistry
implements CompensableBeanFactoryAware,
EnvironmentAware {
    static final Logger logger = LoggerFactory.getLogger(SpringCloudBeanRegistry.class);
    private static final SpringCloudBeanRegistry instance = new SpringCloudBeanRegistry();
    @Inject
    private CompensableBeanFactory beanFactory;
    private RestTemplate restTemplate;
    private ThreadLocal<CompensableLoadBalancerInterceptor> interceptors = new ThreadLocal();
    private Environment environment;

    private SpringCloudBeanRegistry() {
        if (instance != null) {
            throw new IllegalStateException();
        }
    }

    public static SpringCloudBeanRegistry getInstance() {
        return instance;
    }

    public RemoteCoordinator getConsumeCoordinator(String identifier) {
        RemoteCoordinatorRegistry registry = RemoteCoordinatorRegistry.getInstance();
        if (StringUtils.isBlank((CharSequence)identifier)) {
            return null;
        }
        RemoteCoordinator coordinator = registry.getRemoteCoordinator(identifier);
        if (coordinator != null) {
            return coordinator;
        }
        SpringCloudCoordinator handler = new SpringCloudCoordinator();
        handler.setIdentifier(identifier);
        handler.setEnvironment(this.environment);
        coordinator = (RemoteCoordinator)Proxy.newProxyInstance(SpringCloudCoordinator.class.getClassLoader(), new Class[]{RemoteCoordinator.class}, (InvocationHandler)handler);
        registry.putRemoteCoordinator(identifier, coordinator);
        return coordinator;
    }

    public CompensableLoadBalancerInterceptor getLoadBalancerInterceptor() {
        return this.interceptors.get();
    }

    public void setLoadBalancerInterceptor(CompensableLoadBalancerInterceptor interceptor) {
        this.interceptors.set(interceptor);
    }

    public void removeLoadBalancerInterceptor() {
        this.interceptors.remove();
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }

    public CompensableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

