/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

public class SpringCloudCoordinator
implements InvocationHandler {
    static final Logger logger = LoggerFactory.getLogger(SpringCloudCoordinator.class);
    static final String CONSTANT_CONTENT_PATH = "org.bytesoft.bytetcc.contextpath";
    private String identifier;
    private Environment environment;

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        String methodName = method.getName();
        if (Object.class.equals(clazz)) {
            return method.invoke((Object)this, args);
        }
        if (RemoteCoordinator.class.equals(clazz)) {
            if ("getIdentifier".equals(methodName)) {
                return this.identifier;
            }
            if ("getApplication".equals(methodName)) {
                int firstIndex = this.identifier.indexOf(":");
                int lastIndex = this.identifier.lastIndexOf(":");
                return firstIndex <= 0 || lastIndex <= 0 || firstIndex > lastIndex ? null : this.identifier.subSequence(firstIndex + 1, lastIndex);
            }
            throw new XAException(-7);
        }
        if (XAResource.class.equals(clazz)) {
            if ("start".equals(methodName)) {
                return null;
            }
            if ("prepare".equals(methodName)) {
                return this.invokePostCoordinator(proxy, method, args);
            }
            if ("commit".equals(methodName)) {
                return this.invokePostCoordinator(proxy, method, args);
            }
            if ("rollback".equals(methodName)) {
                return this.invokePostCoordinator(proxy, method, args);
            }
            if ("recover".equals(methodName)) {
                return this.invokeGetCoordinator(proxy, method, args);
            }
            if ("forget".equals(methodName)) {
                return this.invokePostCoordinator(proxy, method, args);
            }
            throw new XAException(-7);
        }
        throw new IllegalAccessException();
    }

    public Object invokePostCoordinator(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> returnType = method.getReturnType();
        try {
            RestTemplate transactionRestTemplate = SpringCloudBeanRegistry.getInstance().getRestTemplate();
            RestTemplate restTemplate = transactionRestTemplate == null ? new RestTemplate() : transactionRestTemplate;
            StringBuilder ber = new StringBuilder();
            int firstIndex = this.identifier.indexOf(":");
            int lastIndex = this.identifier.lastIndexOf(":");
            String prefix = firstIndex <= 0 ? null : this.identifier.substring(0, firstIndex);
            String servId = firstIndex <= 0 || lastIndex <= 0 || firstIndex >= lastIndex ? null : this.identifier.substring(firstIndex + 1, lastIndex);
            String suffix = lastIndex <= 0 ? null : this.identifier.substring(lastIndex + 1);
            String contextPathKey = String.format("%s.%s", CONSTANT_CONTENT_PATH, servId);
            String contextPath = StringUtils.isBlank((CharSequence)servId) ? null : StringUtils.trimToEmpty((String)this.environment.getProperty(contextPathKey));
            ber.append("http://");
            ber.append(prefix == null || suffix == null ? null : prefix + ":" + suffix);
            if (StringUtils.isNotBlank((CharSequence)contextPath) || StringUtils.equals((CharSequence)contextPath, (CharSequence)"/")) {
                ber.append(contextPath.startsWith("/") ? "" : "/").append(contextPath);
            }
            ber.append("/org/bytesoft/bytetcc/");
            ber.append(method.getName());
            for (int i = 0; i < args.length; ++i) {
                Serializable arg = (Serializable)args[i];
                ber.append("/").append(this.serialize(arg));
            }
            ResponseEntity response = restTemplate.postForEntity(ber.toString(), null, returnType, new Object[0]);
            return response.getBody();
        }
        catch (HttpClientErrorException ex) {
            XAException xaEx = new XAException(-7);
            xaEx.initCause(ex);
            throw xaEx;
        }
        catch (HttpServerErrorException ex) {
            HttpHeaders headers = ex.getResponseHeaders();
            String failureText = StringUtils.trimToNull((String)headers.getFirst("failure"));
            String errorText = StringUtils.trimToNull((String)headers.getFirst("XA_XAER"));
            Boolean failure = failureText == null ? null : Boolean.valueOf(Boolean.parseBoolean(failureText));
            Integer errorCode = null;
            try {
                errorCode = errorText == null ? null : Integer.valueOf(Integer.parseInt(errorText));
            }
            catch (Exception ignore) {
                logger.debug(ignore.getMessage());
            }
            if (failure != null && errorCode != null) {
                XAException xaEx = new XAException(errorCode);
                xaEx.initCause(ex);
                throw xaEx;
            }
            XAException xaEx = new XAException(-3);
            xaEx.initCause(ex);
            throw xaEx;
        }
        catch (Exception ex) {
            XAException xaEx = new XAException(-3);
            xaEx.initCause(ex);
            throw xaEx;
        }
    }

    public Object invokeGetCoordinator(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> returnType = method.getReturnType();
        try {
            RestTemplate transactionRestTemplate = SpringCloudBeanRegistry.getInstance().getRestTemplate();
            RestTemplate restTemplate = transactionRestTemplate == null ? new RestTemplate() : transactionRestTemplate;
            StringBuilder ber = new StringBuilder();
            int firstIndex = this.identifier.indexOf(":");
            int lastIndex = this.identifier.lastIndexOf(":");
            String prefix = firstIndex <= 0 ? null : this.identifier.substring(0, firstIndex);
            String servId = firstIndex <= 0 || lastIndex <= 0 || firstIndex >= lastIndex ? null : this.identifier.substring(firstIndex + 1, lastIndex);
            String suffix = lastIndex <= 0 ? null : this.identifier.substring(lastIndex + 1);
            String contextPathKey = String.format("%s.%s", CONSTANT_CONTENT_PATH, servId);
            String contextPath = StringUtils.isBlank((CharSequence)servId) ? null : StringUtils.trimToEmpty((String)this.environment.getProperty(contextPathKey));
            ber.append("http://");
            ber.append(prefix == null || suffix == null ? null : prefix + ":" + suffix);
            if (StringUtils.isNotBlank((CharSequence)contextPath) || StringUtils.equals((CharSequence)contextPath, (CharSequence)"/")) {
                ber.append(contextPath.startsWith("/") ? "" : "/").append(contextPath);
            }
            ber.append("/org/bytesoft/bytetcc/");
            ber.append(method.getName());
            for (int i = 0; i < args.length; ++i) {
                Serializable arg = (Serializable)args[i];
                ber.append("/").append(this.serialize(arg));
            }
            ResponseEntity response = restTemplate.getForEntity(ber.toString(), returnType, new Object[0]);
            return response.getBody();
        }
        catch (HttpClientErrorException ex) {
            XAException xaEx = new XAException(-7);
            xaEx.initCause(ex);
            throw xaEx;
        }
        catch (HttpServerErrorException ex) {
            HttpHeaders headers = ex.getResponseHeaders();
            String failureText = StringUtils.trimToNull((String)headers.getFirst("failure"));
            String errorText = StringUtils.trimToNull((String)headers.getFirst("XA_XAER"));
            Boolean failure = failureText == null ? null : Boolean.valueOf(Boolean.parseBoolean(failureText));
            Integer errorCode = null;
            try {
                errorCode = errorText == null ? null : Integer.valueOf(Integer.parseInt(errorText));
            }
            catch (Exception ignore) {
                logger.debug(ignore.getMessage());
            }
            if (failure != null && errorCode != null) {
                XAException xaEx = new XAException(errorCode);
                xaEx.initCause(ex);
                throw xaEx;
            }
            XAException xaEx = new XAException(-3);
            xaEx.initCause(ex);
            throw xaEx;
        }
        catch (Exception ex) {
            XAException xaEx = new XAException(-3);
            xaEx.initCause(ex);
            throw xaEx;
        }
    }

    private String serialize(Serializable arg) throws IOException {
        if (Xid.class.isInstance(arg)) {
            Xid xid = (Xid)((Object)arg);
            byte[] globalTransactionId = xid.getGlobalTransactionId();
            return ByteUtils.byteArrayToString((byte[])globalTransactionId);
        }
        if (Integer.class.isInstance(arg) || Integer.TYPE.isInstance(arg)) {
            return String.valueOf(arg);
        }
        if (Boolean.class.isInstance(arg) || Boolean.TYPE.isInstance(arg)) {
            return String.valueOf(arg);
        }
        byte[] byteArray = CommonUtils.serializeObject((Serializable)arg);
        return ByteUtils.byteArrayToString((byte[])byteArray);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

