/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud;

import java.util.ArrayList;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.aware.CompensableEndpointAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class SpringCloudEndpointPostProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware {
    static final Logger logger = LoggerFactory.getLogger(SpringCloudEndpointPostProcessor.class);
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ArrayList<BeanDefinition> beanDefList = new ArrayList<BeanDefinition>();
        String[] beanNameArray = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanNameArray.length; ++i) {
            String beanName = beanNameArray[i];
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            String beanClassName = beanDef.getBeanClassName();
            Class<?> beanClass = null;
            try {
                beanClass = cl.loadClass(beanClassName);
            }
            catch (Exception ex) {
                logger.debug("Cannot load class {}, beanId= {}!", new Object[]{beanClassName, beanName, ex});
                continue;
            }
            if (!CompensableEndpointAware.class.isAssignableFrom(beanClass)) continue;
            beanDefList.add(beanDef);
        }
        String host = CommonUtils.getInetAddress();
        String name = this.environment.getProperty("spring.application.name");
        String port = this.environment.getProperty("server.port");
        String identifier = String.format("%s:%s:%s", host, name, port);
        for (int i = 0; i < beanDefList.size(); ++i) {
            BeanDefinition beanDef = (BeanDefinition)beanDefList.get(i);
            MutablePropertyValues mpv = beanDef.getPropertyValues();
            mpv.addPropertyValue("endpoint", (Object)identifier);
        }
    }
}

