/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.config;

import feign.Contract;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import feign.hystrix.HystrixFeign;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableClientRegistry;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableFeignBeanPostProcessor;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableFeignContract;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableFeignDecoder;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableFeignErrorDecoder;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableFeignInterceptor;
import org.bytesoft.bytetcc.supports.springcloud.hystrix.CompensableHystrixBeanPostProcessor;
import org.bytesoft.bytetcc.supports.springcloud.property.CompensablePropertySourceFactory;
import org.bytesoft.bytetcc.supports.springcloud.web.CompensableHandlerInterceptor;
import org.bytesoft.bytetcc.supports.springcloud.web.CompensableRequestInterceptor;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.aware.CompensableEndpointAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.Netty4ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PropertySource(value={"bytetcc:loadbalancer.config"}, factory=CompensablePropertySourceFactory.class)
@Configuration
public class SpringCloudConfiguration
extends WebMvcConfigurerAdapter
implements BeanFactoryPostProcessor,
InitializingBean,
CompensableEndpointAware,
EnvironmentAware,
ApplicationContextAware {
    static final String CONSTANT_INCLUSIONS = "org.bytesoft.bytetcc.feign.inclusions";
    static final String CONSTANT_EXCLUSIONS = "org.bytesoft.bytetcc.feign.exclusions";
    static final String FEIGN_FACTORY_CLASS = "org.springframework.cloud.netflix.feign.FeignClientFactoryBean";
    private ApplicationContext applicationContext;
    private String identifier;
    private Environment environment;
    private final transient Set<String> transientClientSet = new HashSet<String>();

    public void afterPropertiesSet() throws Exception {
        String host = CommonUtils.getInetAddress();
        String name = this.environment.getProperty("spring.application.name");
        String port = this.environment.getProperty("server.port");
        this.identifier = String.format("%s:%s:%s", host, name, port);
    }

    @Bean
    @ConditionalOnProperty(name={"feign.hystrix.enabled"}, havingValue="false", matchIfMissing=true)
    public CompensableFeignBeanPostProcessor feignPostProcessor() {
        return new CompensableFeignBeanPostProcessor();
    }

    @Bean
    @ConditionalOnProperty(name={"feign.hystrix.enabled"})
    @ConditionalOnClass(value={HystrixFeign.class})
    public CompensableHystrixBeanPostProcessor hystrixPostProcessor() {
        return new CompensableHystrixBeanPostProcessor();
    }

    @Bean
    public CompensableFeignInterceptor compensableFeignInterceptor() {
        CompensableFeignInterceptor interceptor = new CompensableFeignInterceptor();
        interceptor.setEndpoint(this.identifier);
        return interceptor;
    }

    @Primary
    @Bean
    public Contract compensableFeignContract() {
        return new CompensableFeignContract();
    }

    @Primary
    @Bean
    public Decoder compensableFeignDecoder(@Autowired ObjectFactory<HttpMessageConverters> objectFactory) {
        CompensableFeignDecoder feignDecoder = new CompensableFeignDecoder();
        feignDecoder.setObjectFactory(objectFactory);
        return feignDecoder;
    }

    @Primary
    @Bean
    public ErrorDecoder compensableErrorDecoder() {
        return new CompensableFeignErrorDecoder();
    }

    @Bean
    public CompensableHandlerInterceptor compensableHandlerInterceptor() {
        CompensableHandlerInterceptor interceptor = new CompensableHandlerInterceptor();
        interceptor.setEndpoint(this.identifier);
        return interceptor;
    }

    @Bean
    public CompensableRequestInterceptor compensableRequestInterceptor() {
        CompensableRequestInterceptor interceptor = new CompensableRequestInterceptor();
        interceptor.setEndpoint(this.identifier);
        return interceptor;
    }

    @ConditionalOnMissingBean(value={ClientHttpRequestFactory.class})
    @Bean
    public ClientHttpRequestFactory defaultRequestFactory() {
        return new Netty4ClientHttpRequestFactory();
    }

    @Bean(value={"compensableRestTemplate"})
    public RestTemplate transactionTemplate(@Autowired ClientHttpRequestFactory requestFactory) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(requestFactory);
        SpringCloudBeanRegistry registry = SpringCloudBeanRegistry.getInstance();
        registry.setRestTemplate(restTemplate);
        return restTemplate;
    }

    @Primary
    @LoadBalanced
    @Bean
    public RestTemplate defaultRestTemplate(@Autowired CompensableRequestInterceptor compensableRequestInterceptor) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getInterceptors().add(compensableRequestInterceptor);
        return restTemplate;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        CompensableHandlerInterceptor compensableHandlerInterceptor = (CompensableHandlerInterceptor)this.applicationContext.getBean(CompensableHandlerInterceptor.class);
        registry.addInterceptor((HandlerInterceptor)compensableHandlerInterceptor);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNameArray = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanNameArray.length; ++i) {
            MutablePropertyValues mpv;
            PropertyValue pv;
            String client;
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanNameArray[i]);
            String beanClassName = beanDef.getBeanClassName();
            if (!FEIGN_FACTORY_CLASS.equals(beanClassName) || !StringUtils.isNotBlank((CharSequence)(client = String.valueOf((pv = (mpv = beanDef.getPropertyValues()).getPropertyValue("name")).getValue() == null ? "" : pv.getValue())))) continue;
            this.transientClientSet.add(client);
        }
        this.fireAfterPropertiesSet();
    }

    public void fireAfterPropertiesSet() {
        CompensableClientRegistry registry = CompensableClientRegistry.getInstance();
        String inclusions = this.environment.getProperty(CONSTANT_INCLUSIONS);
        String exclusions = this.environment.getProperty(CONSTANT_EXCLUSIONS);
        if (StringUtils.isNotBlank((CharSequence)inclusions) && StringUtils.isNotBlank((CharSequence)exclusions)) {
            throw new IllegalStateException(String.format("Property '%s' and '%s' can not be configured together!", CONSTANT_INCLUSIONS, CONSTANT_EXCLUSIONS));
        }
        if (StringUtils.isNotBlank((CharSequence)inclusions)) {
            String[] clients = inclusions.split("\\s*,\\s*");
            for (int i = 0; i < clients.length; ++i) {
                String client = clients[i];
                registry.registerClient(client);
            }
            this.transientClientSet.clear();
        } else if (StringUtils.isNotBlank((CharSequence)exclusions)) {
            String client;
            String[] clients = exclusions.split("\\s*,\\s*");
            for (int i = 0; i < clients.length; ++i) {
                client = clients[i];
                this.transientClientSet.remove(client);
            }
            Iterator<String> itr = this.transientClientSet.iterator();
            while (itr.hasNext()) {
                client = itr.next();
                itr.remove();
                registry.registerClient(client);
            }
        } else {
            Iterator<String> itr = this.transientClientSet.iterator();
            while (itr.hasNext()) {
                String client = itr.next();
                itr.remove();
                registry.registerClient(client);
            }
        }
    }

    public void setEndpoint(String identifier) {
        this.identifier = identifier;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

