/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.controller;

import java.beans.PropertyEditorSupport;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.bytesoft.bytetcc.CompensableCoordinator;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CompensableCoordinatorController
extends PropertyEditorSupport
implements CompensableBeanFactoryAware {
    static final Logger logger = LoggerFactory.getLogger(CompensableCoordinatorController.class);
    @Autowired
    private CompensableCoordinator compensableCoordinator;
    @Autowired
    private CompensableBeanFactory beanFactory;

    @RequestMapping(value={"/org/bytesoft/bytetcc/prepare/{xid}"}, method={RequestMethod.POST})
    @ResponseBody
    public int prepare(@PathVariable(value="xid") String identifier, HttpServletResponse response) {
        try {
            XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
            byte[] byteArray = ByteUtils.stringToByteArray((String)identifier);
            TransactionXid xid = xidFactory.createGlobalXid(byteArray);
            return this.compensableCoordinator.prepare((Xid)xid);
        }
        catch (XAException ex) {
            logger.error("Error occurred while preparing transaction: {}.", (Object)identifier, (Object)ex);
            response.addHeader("failure", "true");
            response.addHeader("XA_XAER", String.valueOf(ex.errorCode));
            response.setStatus(500);
            return -1;
        }
        catch (RuntimeException ex) {
            logger.error("Error occurred while preparing transaction: {}.", (Object)identifier, (Object)ex);
            response.addHeader("failure", "true");
            response.setStatus(500);
            return -1;
        }
    }

    @RequestMapping(value={"/org/bytesoft/bytetcc/commit/{xid}/{opc}"}, method={RequestMethod.POST})
    @ResponseBody
    public void commit(@PathVariable(value="xid") String identifier, @PathVariable(value="opc") boolean onePhase, HttpServletResponse response) {
        try {
            XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
            byte[] byteArray = ByteUtils.stringToByteArray((String)identifier);
            TransactionXid xid = xidFactory.createGlobalXid(byteArray);
            this.compensableCoordinator.commit((Xid)xid, onePhase);
        }
        catch (XAException ex) {
            logger.error("Error occurred while committing transaction: {}.", (Object)identifier, (Object)ex);
            response.addHeader("failure", "true");
            response.addHeader("XA_XAER", String.valueOf(ex.errorCode));
            response.setStatus(500);
        }
        catch (RuntimeException ex) {
            logger.error("Error occurred while committing transaction: {}.", (Object)identifier, (Object)ex);
            response.addHeader("failure", "true");
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/org/bytesoft/bytetcc/rollback/{xid}"}, method={RequestMethod.POST})
    @ResponseBody
    public void rollback(@PathVariable(value="xid") String identifier, HttpServletResponse response) {
        try {
            XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
            byte[] byteArray = ByteUtils.stringToByteArray((String)identifier);
            TransactionXid xid = xidFactory.createGlobalXid(byteArray);
            this.compensableCoordinator.rollback((Xid)xid);
        }
        catch (XAException ex) {
            logger.error("Error occurred while rolling back transaction: {}.", (Object)identifier, (Object)ex);
            response.addHeader("failure", "true");
            response.addHeader("XA_XAER", String.valueOf(ex.errorCode));
            response.setStatus(500);
        }
        catch (RuntimeException ex) {
            logger.error("Error occurred while rolling back transaction: {}.", (Object)identifier, (Object)ex);
            response.addHeader("failure", "true");
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/org/bytesoft/bytetcc/recover/{flag}"}, method={RequestMethod.GET})
    @ResponseBody
    public Xid[] recover(@PathVariable(value="flag") int flag, HttpServletResponse response) {
        try {
            return this.compensableCoordinator.recover(flag);
        }
        catch (XAException ex) {
            logger.error("Error occurred while recovering transactions.", (Throwable)ex);
            response.addHeader("failure", "true");
            response.addHeader("XA_XAER", String.valueOf(ex.errorCode));
            response.setStatus(500);
            return new Xid[0];
        }
        catch (RuntimeException ex) {
            logger.error("Error occurred while recovering transactions.", (Throwable)ex);
            response.addHeader("failure", "true");
            response.setStatus(500);
            return new Xid[0];
        }
    }

    @RequestMapping(value={"/org/bytesoft/bytetcc/forget/{xid}"}, method={RequestMethod.POST})
    @ResponseBody
    public void forget(@PathVariable(value="xid") String identifier, HttpServletResponse response) {
        try {
            XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
            byte[] byteArray = ByteUtils.stringToByteArray((String)identifier);
            TransactionXid xid = xidFactory.createGlobalXid(byteArray);
            this.compensableCoordinator.forget((Xid)xid);
        }
        catch (XAException ex) {
            logger.error("Error occurred while forgetting transaction: {}.", (Object)identifier, (Object)ex);
            response.addHeader("failure", "true");
            response.addHeader("XA_XAER", String.valueOf(ex.errorCode));
            response.setStatus(500);
        }
        catch (RuntimeException ex) {
            logger.error("Error occurred while forgetting transaction: {}.", (Object)identifier, (Object)ex);
            response.addHeader("failure", "true");
            response.setStatus(500);
        }
    }

    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }
}

