/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.feign;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableFeignHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class CompensableFeignBeanPostProcessor
implements BeanPostProcessor {
    static final String FEIGN_CLAZZ_NAME = "feign.ReflectiveFeign$FeignInvocationHandler";

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!Proxy.isProxyClass(bean.getClass())) {
            return bean;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(bean);
        if (!StringUtils.equals((CharSequence)FEIGN_CLAZZ_NAME, (CharSequence)handler.getClass().getName())) {
            return bean;
        }
        CompensableFeignHandler feignHandler = new CompensableFeignHandler();
        feignHandler.setDelegate(handler);
        Class<?> clazz = bean.getClass();
        Class<?>[] interfaces = clazz.getInterfaces();
        ClassLoader loader = clazz.getClassLoader();
        return Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)feignHandler);
    }
}

