/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.feign;

import feign.Contract;
import feign.MethodMetadata;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.netflix.feign.support.SpringMvcContract;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompensableFeignContract
implements Contract,
InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private Contract delegate;

    public CompensableFeignContract() {
    }

    public CompensableFeignContract(Contract contract) {
        this.delegate = contract;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.delegate == null) {
            this.invokeAfterPropertiesSet();
        }
    }

    public void invokeAfterPropertiesSet() throws Exception {
        SpringMvcContract feignContract = null;
        String[] beanNameArray = this.applicationContext.getBeanNamesForType(Contract.class);
        for (int i = 0; beanNameArray != null && i < beanNameArray.length; ++i) {
            String beanName = beanNameArray[i];
            Object beanInst = this.applicationContext.getBean(beanName);
            if (CompensableFeignContract.class.isInstance(beanInst)) continue;
            if (feignContract != null) {
                throw new RuntimeException("There are more than one feign.Contract exists!");
            }
            feignContract = (Contract)beanInst;
        }
        if (feignContract == null) {
            feignContract = new SpringMvcContract();
        }
        this.delegate = feignContract;
    }

    public List<MethodMetadata> parseAndValidatateMetadata(Class<?> targetType) {
        List metas = this.delegate.parseAndValidatateMetadata(targetType);
        for (int i = 0; metas != null && i < metas.size(); ++i) {
            MethodMetadata meta = (MethodMetadata)metas.get(i);
            if (meta.returnType() != Void.TYPE) continue;
            meta.returnType(Void.class);
        }
        return metas == null ? new ArrayList() : metas;
    }

    public Contract getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Contract delegate) {
        this.delegate = delegate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

