/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.feign;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bytesoft.bytejta.supports.rpc.TransactionRequestImpl;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.bytetcc.CompensableTransactionImpl;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.bytetcc.supports.springcloud.loadbalancer.CompensableLoadBalancerInterceptor;
import org.bytesoft.bytetcc.supports.springcloud.rpc.TransactionResponseImpl;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableManager;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.transaction.supports.rpc.TransactionInterceptor;
import org.bytesoft.transaction.supports.rpc.TransactionRequest;
import org.bytesoft.transaction.supports.rpc.TransactionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensableFeignHandler
implements InvocationHandler {
    static final Logger logger = LoggerFactory.getLogger(CompensableFeignHandler.class);
    private InvocationHandler delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        final SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        CompensableManager compensableManager = beanFactory.getCompensableManager();
        final TransactionInterceptor transactionInterceptor = beanFactory.getTransactionInterceptor();
        CompensableTransactionImpl compensable = (CompensableTransactionImpl)compensableManager.getCompensableTransactionQuietly();
        if (compensable == null) {
            return this.delegate.invoke(proxy, method, args);
        }
        final TransactionContext transactionContext = compensable.getTransactionContext();
        if (!transactionContext.isCompensable()) {
            return this.delegate.invoke(proxy, method, args);
        }
        final TransactionRequestImpl request = new TransactionRequestImpl();
        TransactionResponseImpl response = new TransactionResponseImpl();
        final Map participants = compensable.getParticipantArchiveMap();
        beanRegistry.setLoadBalancerInterceptor(new CompensableLoadBalancerInterceptor(){

            @Override
            public List<Server> beforeCompletion(List<Server> servers) {
                ArrayList<Server> readyServerList = new ArrayList<Server>();
                ArrayList<Server> unReadyServerList = new ArrayList<Server>();
                for (int i = 0; servers != null && i < servers.size(); ++i) {
                    int port;
                    String appName;
                    String addr;
                    Server server = servers.get(i);
                    String instanceId = null;
                    if (DiscoveryEnabledServer.class.isInstance(server)) {
                        DiscoveryEnabledServer discoveryEnabledServer = (DiscoveryEnabledServer)server;
                        InstanceInfo instanceInfo = discoveryEnabledServer.getInstanceInfo();
                        addr = instanceInfo.getIPAddr();
                        appName = instanceInfo.getAppName();
                        port = instanceInfo.getPort();
                        instanceId = String.format("%s:%s:%s", addr, appName, port);
                    } else {
                        Server.MetaInfo metaInfo = server.getMetaInfo();
                        String host = server.getHost();
                        addr = host.matches("\\d+(\\.\\d+){3}") ? host : CommonUtils.getInetAddress((String)host);
                        appName = metaInfo.getAppName();
                        port = server.getPort();
                        instanceId = String.format("%s:%s:%s", addr, appName, port);
                    }
                    if (participants.containsKey(instanceId)) {
                        ArrayList<Server> serverList = new ArrayList<Server>();
                        serverList.add(server);
                        return serverList;
                    }
                    if (server.isReadyToServe()) {
                        readyServerList.add(server);
                        continue;
                    }
                    unReadyServerList.add(server);
                }
                logger.warn("There is no suitable server: expect= {}, actual= {}!", participants.keySet(), servers);
                return readyServerList.isEmpty() ? unReadyServerList : readyServerList;
            }

            @Override
            public void afterCompletion(Server server) {
                beanRegistry.removeLoadBalancerInterceptor();
                if (server == null) {
                    logger.warn("There is no suitable server, the TransactionInterceptor.beforeSendRequest() operation is not executed!");
                    return;
                }
                request.setTransactionContext((org.bytesoft.transaction.TransactionContext)transactionContext);
                String instanceId = null;
                if (DiscoveryEnabledServer.class.isInstance(server)) {
                    DiscoveryEnabledServer discoveryEnabledServer = (DiscoveryEnabledServer)server;
                    InstanceInfo instanceInfo = discoveryEnabledServer.getInstanceInfo();
                    String addr = instanceInfo.getIPAddr();
                    String appName = instanceInfo.getAppName();
                    int port = instanceInfo.getPort();
                    instanceId = String.format("%s:%s:%s", addr, appName, port);
                } else {
                    Server.MetaInfo metaInfo = server.getMetaInfo();
                    String host = server.getHost();
                    String addr = host.matches("\\d+(\\.\\d+){3}") ? host : CommonUtils.getInetAddress((String)host);
                    String appName = metaInfo.getAppName();
                    int port = server.getPort();
                    instanceId = String.format("%s:%s:%s", addr, appName, port);
                }
                RemoteCoordinator coordinator = beanRegistry.getConsumeCoordinator(instanceId);
                request.setTargetTransactionCoordinator(coordinator);
                transactionInterceptor.beforeSendRequest((TransactionRequest)request);
            }
        });
        try {
            Object object = this.delegate.invoke(proxy, method, args);
            return object;
        }
        finally {
            if (!response.isIntercepted()) {
                response.setTransactionContext((org.bytesoft.transaction.TransactionContext)transactionContext);
                RemoteCoordinator coordinator = request.getTargetTransactionCoordinator();
                response.setSourceTransactionCoordinator(coordinator);
                response.setParticipantEnlistFlag(request.isParticipantEnlistFlag());
                transactionInterceptor.afterReceiveResponse((TransactionResponse)response);
            }
        }
    }

    public InvocationHandler getDelegate() {
        return this.delegate;
    }

    public void setDelegate(InvocationHandler delegate) {
        this.delegate = delegate;
    }
}

