/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableManager;
import org.bytesoft.compensable.CompensableTransaction;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.compensable.aware.CompensableEndpointAware;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CompensableFeignInterceptor
implements RequestInterceptor,
CompensableEndpointAware,
ApplicationContextAware {
    static final String HEADER_TRANCACTION_KEY = "org.bytesoft.bytetcc.transaction";
    static final String HEADER_PROPAGATION_KEY = "org.bytesoft.bytetcc.propagation";
    private String identifier;
    private ApplicationContext applicationContext;

    public void apply(RequestTemplate template) {
        SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        CompensableManager compensableManager = beanFactory.getCompensableManager();
        CompensableTransaction compensable = compensableManager.getCompensableTransactionQuietly();
        if (compensable == null) {
            return;
        }
        try {
            TransactionContext transactionContext = compensable.getTransactionContext();
            byte[] byteArray = CommonUtils.serializeObject((Serializable)transactionContext);
            String transactionText = ByteUtils.byteArrayToString((byte[])byteArray);
            Map headers = template.headers();
            if (!headers.containsKey(HEADER_TRANCACTION_KEY)) {
                template.header(HEADER_TRANCACTION_KEY, new String[]{transactionText});
            }
            if (!headers.containsKey(HEADER_PROPAGATION_KEY)) {
                template.header(HEADER_PROPAGATION_KEY, new String[]{this.identifier});
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error occurred while preparing the transaction context!", ex);
        }
    }

    public void setEndpoint(String identifier) {
        this.identifier = identifier;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

