/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.property;

import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytetcc.supports.springcloud.feign.CompensableClientRegistry;
import org.bytesoft.bytetcc.supports.springcloud.loadbalancer.CompensableLoadBalancerRuleImpl;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.support.EncodedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompensablePropertySource
extends PropertySource<Object> {
    private boolean enabled;

    public CompensablePropertySource(String name, EncodedResource source) {
        super(name, (Object)source);
        EncodedResource encoded = (EncodedResource)this.getSource();
        AbstractResource resource = (AbstractResource)encoded.getResource();
        String path = resource.getFilename();
        if (StringUtils.isBlank((CharSequence)path)) {
            return;
        }
        String[] values = path.split(":");
        if (values.length != 2) {
            return;
        }
        String protocol = values[0];
        String resName = values[1];
        if (!"bytetcc".equalsIgnoreCase(protocol)) {
            return;
        }
        if (!"loadbalancer.config".equalsIgnoreCase(resName)) {
            return;
        }
        this.enabled = true;
    }

    public Object getProperty(String name) {
        if (!this.enabled || name == null || StringUtils.isBlank((CharSequence)name) || name.indexOf(".") < 0) {
            return null;
        }
        CompensableClientRegistry registry = CompensableClientRegistry.getInstance();
        int index = name.indexOf(".");
        String client = name.substring(0, index);
        String suffix = name.substring(index);
        if (registry.containsClient(client) && ".ribbon.NFLoadBalancerRuleClassName".equals(suffix)) {
            return CompensableLoadBalancerRuleImpl.class.getName();
        }
        return null;
    }
}

