/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.web;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.bytesoft.bytejta.supports.rpc.TransactionRequestImpl;
import org.bytesoft.bytejta.supports.rpc.TransactionResponseImpl;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.bytetcc.supports.springcloud.controller.CompensableCoordinatorController;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.Compensable;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableManager;
import org.bytesoft.compensable.CompensableTransaction;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.compensable.aware.CompensableEndpointAware;
import org.bytesoft.transaction.supports.rpc.TransactionInterceptor;
import org.bytesoft.transaction.supports.rpc.TransactionRequest;
import org.bytesoft.transaction.supports.rpc.TransactionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class CompensableHandlerInterceptor
implements HandlerInterceptor,
CompensableEndpointAware,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(CompensableHandlerInterceptor.class);
    static final String HEADER_TRANCACTION_KEY = "org.bytesoft.bytetcc.transaction";
    static final String HEADER_PROPAGATION_KEY = "org.bytesoft.bytetcc.propagation";
    private String identifier;
    private ApplicationContext applicationContext;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!HandlerMethod.class.isInstance(handler)) {
            logger.warn("CompensableHandlerInterceptor cannot handle current request(uri= {}, handler= {}) correctly.", (Object)request.getRequestURI(), handler);
            return true;
        }
        HandlerMethod hm = (HandlerMethod)handler;
        Class clazz = hm.getBeanType();
        if (CompensableCoordinatorController.class.equals((Object)clazz)) {
            return true;
        }
        if (ErrorController.class.isInstance(hm.getBean())) {
            return true;
        }
        String transactionStr = request.getHeader(HEADER_TRANCACTION_KEY);
        if (StringUtils.isBlank((String)transactionStr)) {
            return true;
        }
        String propagationStr = request.getHeader(HEADER_PROPAGATION_KEY);
        String transactionText = StringUtils.trimToNull((String)transactionStr);
        String propagationText = StringUtils.trimToNull((String)propagationStr);
        Compensable annotation = clazz.getAnnotation(Compensable.class);
        if (annotation == null) {
            return true;
        }
        SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        TransactionInterceptor transactionInterceptor = beanFactory.getTransactionInterceptor();
        byte[] byteArray = transactionText == null ? new byte[]{} : ByteUtils.stringToByteArray((String)transactionText);
        TransactionContext transactionContext = null;
        if (byteArray != null && byteArray.length > 0) {
            transactionContext = (TransactionContext)CommonUtils.deserializeObject((byte[])byteArray);
            transactionContext.setPropagated(true);
            transactionContext.setPropagatedBy((Object)propagationText);
        }
        TransactionRequestImpl req = new TransactionRequestImpl();
        req.setTransactionContext((org.bytesoft.transaction.TransactionContext)transactionContext);
        req.setTargetTransactionCoordinator(beanRegistry.getConsumeCoordinator(propagationText));
        transactionInterceptor.afterReceiveRequest((TransactionRequest)req);
        CompensableManager compensableManager = beanFactory.getCompensableManager();
        CompensableTransaction compensable = compensableManager.getCompensableTransactionQuietly();
        byte[] responseByteArray = CommonUtils.serializeObject((Serializable)compensable.getTransactionContext());
        String compensableStr = ByteUtils.byteArrayToString((byte[])responseByteArray);
        response.setHeader(HEADER_TRANCACTION_KEY, compensableStr);
        response.setHeader(HEADER_PROPAGATION_KEY, this.identifier);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (!HandlerMethod.class.isInstance(handler)) {
            return;
        }
        HandlerMethod hm = (HandlerMethod)handler;
        Class clazz = hm.getBeanType();
        if (CompensableCoordinatorController.class.equals((Object)clazz)) {
            return;
        }
        if (ErrorController.class.isInstance(hm.getBean())) {
            return;
        }
        String transactionStr = request.getHeader(HEADER_TRANCACTION_KEY);
        if (StringUtils.isBlank((String)transactionStr)) {
            return;
        }
        Compensable annotation = clazz.getAnnotation(Compensable.class);
        if (annotation == null) {
            return;
        }
        SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        CompensableManager compensableManager = beanFactory.getCompensableManager();
        TransactionInterceptor transactionInterceptor = beanFactory.getTransactionInterceptor();
        CompensableTransaction compensable = compensableManager.getCompensableTransactionQuietly();
        TransactionContext transactionContext = compensable.getTransactionContext();
        TransactionResponseImpl resp = new TransactionResponseImpl();
        resp.setTransactionContext((org.bytesoft.transaction.TransactionContext)transactionContext);
        resp.setSourceTransactionCoordinator(beanRegistry.getConsumeCoordinator(null));
        transactionInterceptor.beforeSendResponse((TransactionResponse)resp);
    }

    public void setEndpoint(String identifier) {
        this.identifier = identifier;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

