/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.supports.springcloud.web;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.supports.rpc.TransactionRequestImpl;
import org.bytesoft.bytejta.supports.rpc.TransactionResponseImpl;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.bytetcc.CompensableTransactionImpl;
import org.bytesoft.bytetcc.supports.springcloud.SpringCloudBeanRegistry;
import org.bytesoft.bytetcc.supports.springcloud.loadbalancer.CompensableLoadBalancerInterceptor;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableManager;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.compensable.aware.CompensableEndpointAware;
import org.bytesoft.transaction.supports.rpc.TransactionInterceptor;
import org.bytesoft.transaction.supports.rpc.TransactionRequest;
import org.bytesoft.transaction.supports.rpc.TransactionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.HttpClientErrorException;

public class CompensableRequestInterceptor
implements ClientHttpRequestInterceptor,
CompensableEndpointAware,
ApplicationContextAware {
    static final Logger logger = LoggerFactory.getLogger(CompensableRequestInterceptor.class);
    static final String HEADER_TRANCACTION_KEY = "org.bytesoft.bytetcc.transaction";
    static final String HEADER_PROPAGATION_KEY = "org.bytesoft.bytetcc.propagation";
    static final String PREFIX_TRANSACTION_KEY = "/org/bytesoft/bytetcc";
    private String identifier;
    private ApplicationContext applicationContext;

    public ClientHttpResponse intercept(final HttpRequest httpRequest, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String pathWithoutContextPath;
        SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        CompensableManager compensableManager = beanFactory.getCompensableManager();
        CompensableTransactionImpl compensable = (CompensableTransactionImpl)compensableManager.getCompensableTransactionQuietly();
        String path = httpRequest.getURI().getPath();
        int position = path.startsWith("/") ? path.indexOf("/", 1) : -1;
        String string = pathWithoutContextPath = position > 0 ? path.substring(position) : null;
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)PREFIX_TRANSACTION_KEY) || StringUtils.startsWith((CharSequence)pathWithoutContextPath, (CharSequence)PREFIX_TRANSACTION_KEY)) {
            return execution.execute(httpRequest, body);
        }
        if (compensable == null) {
            return execution.execute(httpRequest, body);
        }
        if (!compensable.getTransactionContext().isCompensable()) {
            return execution.execute(httpRequest, body);
        }
        final Map participants = compensable.getParticipantArchiveMap();
        beanRegistry.setLoadBalancerInterceptor(new CompensableLoadBalancerInterceptor(){

            @Override
            public List<Server> beforeCompletion(List<Server> servers) {
                ArrayList<Server> readyServerList = new ArrayList<Server>();
                ArrayList<Server> unReadyServerList = new ArrayList<Server>();
                for (int i = 0; servers != null && i < servers.size(); ++i) {
                    int port;
                    String appName;
                    String addr;
                    Server server = servers.get(i);
                    String instanceId = null;
                    if (DiscoveryEnabledServer.class.isInstance(server)) {
                        DiscoveryEnabledServer discoveryEnabledServer = (DiscoveryEnabledServer)server;
                        InstanceInfo instanceInfo = discoveryEnabledServer.getInstanceInfo();
                        addr = instanceInfo.getIPAddr();
                        appName = instanceInfo.getAppName();
                        port = instanceInfo.getPort();
                        instanceId = String.format("%s:%s:%s", addr, appName, port);
                    } else {
                        Server.MetaInfo metaInfo = server.getMetaInfo();
                        String host = server.getHost();
                        addr = host.matches("\\d+(\\.\\d+){3}") ? host : CommonUtils.getInetAddress((String)host);
                        appName = metaInfo.getAppName();
                        port = server.getPort();
                        instanceId = String.format("%s:%s:%s", addr, appName, port);
                    }
                    if (participants.containsKey(instanceId)) {
                        ArrayList<Server> serverList = new ArrayList<Server>();
                        serverList.add(server);
                        return serverList;
                    }
                    if (server.isReadyToServe()) {
                        readyServerList.add(server);
                        continue;
                    }
                    unReadyServerList.add(server);
                }
                logger.warn("There is no suitable server: expect= {}, actual= {}!", participants.keySet(), servers);
                return readyServerList.isEmpty() ? unReadyServerList : readyServerList;
            }

            @Override
            public void afterCompletion(Server server) {
                if (server == null) {
                    logger.warn("There is no suitable server, the TransactionInterceptor.beforeSendRequest() operation is not executed!");
                    return;
                }
                try {
                    String instanceId = null;
                    if (DiscoveryEnabledServer.class.isInstance(server)) {
                        DiscoveryEnabledServer discoveryEnabledServer = (DiscoveryEnabledServer)server;
                        InstanceInfo instanceInfo = discoveryEnabledServer.getInstanceInfo();
                        String addr = instanceInfo.getIPAddr();
                        String appName = instanceInfo.getAppName();
                        int port = instanceInfo.getPort();
                        instanceId = String.format("%s:%s:%s", addr, appName, port);
                    } else {
                        Server.MetaInfo metaInfo = server.getMetaInfo();
                        String host = server.getHost();
                        String addr = host.matches("\\d+(\\.\\d+){3}") ? host : CommonUtils.getInetAddress((String)host);
                        String appName = metaInfo.getAppName();
                        int port = server.getPort();
                        instanceId = String.format("%s:%s:%s", addr, appName, port);
                    }
                    CompensableRequestInterceptor.this.invokeBeforeSendRequest(httpRequest, instanceId);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        ClientHttpResponse httpResponse = null;
        boolean serverFlag = true;
        try {
            ClientHttpResponse clientHttpResponse = httpResponse = execution.execute(httpRequest, body);
            return clientHttpResponse;
        }
        catch (HttpClientErrorException clientEx) {
            serverFlag = false;
            throw clientEx;
        }
        finally {
            beanRegistry.removeLoadBalancerInterceptor();
            if (httpResponse != null) {
                this.invokeAfterRecvResponse(httpResponse, serverFlag);
            }
        }
    }

    private void invokeBeforeSendRequest(HttpRequest httpRequest, String identifier) throws IOException {
        SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        CompensableManager compensableManager = beanFactory.getCompensableManager();
        TransactionInterceptor transactionInterceptor = beanFactory.getTransactionInterceptor();
        CompensableTransactionImpl compensable = (CompensableTransactionImpl)compensableManager.getCompensableTransactionQuietly();
        TransactionContext transactionContext = compensable.getTransactionContext();
        byte[] reqByteArray = CommonUtils.serializeObject((Serializable)transactionContext);
        String reqTransactionStr = ByteUtils.byteArrayToString((byte[])reqByteArray);
        HttpHeaders reqHeaders = httpRequest.getHeaders();
        reqHeaders.add(HEADER_TRANCACTION_KEY, reqTransactionStr);
        reqHeaders.add(HEADER_PROPAGATION_KEY, this.identifier);
        TransactionRequestImpl request = new TransactionRequestImpl();
        request.setTransactionContext((org.bytesoft.transaction.TransactionContext)transactionContext);
        RemoteCoordinator coordinator = beanRegistry.getConsumeCoordinator(identifier);
        request.setTargetTransactionCoordinator(coordinator);
        transactionInterceptor.beforeSendRequest((TransactionRequest)request);
    }

    private void invokeAfterRecvResponse(ClientHttpResponse httpResponse, boolean serverFlag) throws IOException {
        SpringCloudBeanRegistry beanRegistry = SpringCloudBeanRegistry.getInstance();
        CompensableBeanFactory beanFactory = beanRegistry.getBeanFactory();
        TransactionInterceptor transactionInterceptor = beanFactory.getTransactionInterceptor();
        HttpHeaders respHeaders = httpResponse.getHeaders();
        String respTransactionStr = respHeaders.getFirst(HEADER_TRANCACTION_KEY);
        String respPropagationStr = respHeaders.getFirst(HEADER_PROPAGATION_KEY);
        byte[] byteArray = ByteUtils.stringToByteArray((String)StringUtils.trimToNull((String)respTransactionStr));
        TransactionContext serverContext = (TransactionContext)CommonUtils.deserializeObject((byte[])byteArray);
        TransactionResponseImpl txResp = new TransactionResponseImpl();
        txResp.setTransactionContext((org.bytesoft.transaction.TransactionContext)serverContext);
        RemoteCoordinator serverCoordinator = beanRegistry.getConsumeCoordinator(respPropagationStr);
        txResp.setSourceTransactionCoordinator(serverCoordinator);
        txResp.setParticipantDelistFlag(!serverFlag);
        transactionInterceptor.afterReceiveResponse((TransactionResponse)txResp);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setEndpoint(String identifier) {
        this.identifier = identifier;
    }
}

