/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.windows;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Errno implements Constant
{
    E2BIG(7),
    ENFILE(23),
    EPERM(1),
    EDEADLK(36),
    EBADF(9),
    EMFILE(24),
    ENXIO(6),
    ECHILD(10),
    ERANGE(34),
    EBUSY(16),
    EAGAIN(11),
    ESPIPE(29),
    EFBIG(27),
    EINVAL(22),
    EXDEV(18),
    EACCES(13),
    EIO(5),
    EDOM(33),
    ENOTEMPTY(41),
    ENOLCK(39),
    EINTR(4),
    ENOTDIR(20),
    EROFS(30),
    EISDIR(21),
    ENOMEM(12),
    ENODEV(19),
    ENOSPC(28),
    ENOEXEC(8),
    ENOSYS(40),
    EEXIST(17),
    ENOTTY(25),
    ENAMETOOLONG(38),
    EPIPE(32),
    ESRCH(3),
    EILSEQ(42),
    EFAULT(14),
    ENOENT(2),
    EMLINK(31);

    private final int value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 42L;

    private Errno(int value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return this.value;
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map2 = new EnumMap<Errno, String>(Errno.class);
            map2.put(E2BIG, "Arg list too long");
            map2.put(ENFILE, "Too many open files in system");
            map2.put(EPERM, "Operation not permitted");
            map2.put(EDEADLK, "Resource deadlock avoided");
            map2.put(EBADF, "Bad file descriptor");
            map2.put(EMFILE, "Too many open files");
            map2.put(ENXIO, "No such device or address");
            map2.put(ECHILD, "No child processes");
            map2.put(ERANGE, "Result too large");
            map2.put(EBUSY, "Resource device");
            map2.put(EAGAIN, "Resource temporarily unavailable");
            map2.put(ESPIPE, "Invalid seek");
            map2.put(EFBIG, "File too large");
            map2.put(EINVAL, "Invalid argument");
            map2.put(EXDEV, "Improper link");
            map2.put(EACCES, "Permission denied");
            map2.put(EIO, "Input/output error");
            map2.put(EDOM, "Domain error");
            map2.put(ENOTEMPTY, "Directory not empty");
            map2.put(ENOLCK, "No locks available");
            map2.put(EINTR, "Interrupted function call");
            map2.put(ENOTDIR, "Not a directory");
            map2.put(EROFS, "Read-only file system");
            map2.put(EISDIR, "Is a directory");
            map2.put(ENOMEM, "Not enough space");
            map2.put(ENODEV, "No such device");
            map2.put(ENOSPC, "No space left on device");
            map2.put(ENOEXEC, "Exec format error");
            map2.put(ENOSYS, "Function not implemented");
            map2.put(EEXIST, "File exists");
            map2.put(ENOTTY, "Inappropriate I/O control operation");
            map2.put(ENAMETOOLONG, "Filename too long");
            map2.put(EPIPE, "Broken pipe");
            map2.put(ESRCH, "No such process");
            map2.put(EILSEQ, "Illegal byte sequence");
            map2.put(EFAULT, "Bad address");
            map2.put(ENOENT, "No such file or directory");
            map2.put(EMLINK, "Too many links");
            return map2;
        }
    }
}

