/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.util.retry;

import java.time.Duration;
import java.util.function.Function;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.scheduler.Schedulers;
import org.neo4j.driver.internal.shaded.reactor.util.retry.ImmutableRetrySignal;
import org.neo4j.driver.internal.shaded.reactor.util.retry.RetryBackoffSpec;
import org.neo4j.driver.internal.shaded.reactor.util.retry.RetrySpec;
import org.reactivestreams.Publisher;

public abstract class Retry {
    public abstract Publisher<?> generateCompanion(Flux<RetrySignal> var1);

    public static RetryBackoffSpec backoff(long maxAttempts, Duration minBackoff) {
        return new RetryBackoffSpec(maxAttempts, t -> true, false, minBackoff, RetrySpec.MAX_BACKOFF, 0.5, Schedulers::parallel, RetrySpec.NO_OP_CONSUMER, RetrySpec.NO_OP_CONSUMER, RetrySpec.NO_OP_BIFUNCTION, RetrySpec.NO_OP_BIFUNCTION, RetryBackoffSpec.BACKOFF_EXCEPTION_GENERATOR);
    }

    public static RetryBackoffSpec fixedDelay(long maxAttempts, Duration fixedDelay) {
        return new RetryBackoffSpec(maxAttempts, t -> true, false, fixedDelay, fixedDelay, 0.0, Schedulers::parallel, RetrySpec.NO_OP_CONSUMER, RetrySpec.NO_OP_CONSUMER, RetrySpec.NO_OP_BIFUNCTION, RetrySpec.NO_OP_BIFUNCTION, RetryBackoffSpec.BACKOFF_EXCEPTION_GENERATOR);
    }

    public static RetrySpec max(long max) {
        return new RetrySpec(max, t -> true, false, RetrySpec.NO_OP_CONSUMER, RetrySpec.NO_OP_CONSUMER, RetrySpec.NO_OP_BIFUNCTION, RetrySpec.NO_OP_BIFUNCTION, RetrySpec.RETRY_EXCEPTION_GENERATOR);
    }

    public static RetrySpec maxInARow(long maxInARow) {
        return new RetrySpec(maxInARow, t -> true, true, RetrySpec.NO_OP_CONSUMER, RetrySpec.NO_OP_CONSUMER, RetrySpec.NO_OP_BIFUNCTION, RetrySpec.NO_OP_BIFUNCTION, RetrySpec.RETRY_EXCEPTION_GENERATOR);
    }

    public static RetrySpec indefinitely() {
        return new RetrySpec(Long.MAX_VALUE, t -> true, false, RetrySpec.NO_OP_CONSUMER, RetrySpec.NO_OP_CONSUMER, RetrySpec.NO_OP_BIFUNCTION, RetrySpec.NO_OP_BIFUNCTION, RetrySpec.RETRY_EXCEPTION_GENERATOR);
    }

    public static final Retry from(final Function<Flux<RetrySignal>, Publisher<?>> function) {
        return new Retry(){

            @Override
            public Publisher<?> generateCompanion(Flux<RetrySignal> retrySignalCompanion) {
                return (Publisher)function.apply(retrySignalCompanion);
            }
        };
    }

    public static interface RetrySignal {
        public long totalRetries();

        public long totalRetriesInARow();

        public Throwable failure();

        default public RetrySignal copy() {
            return new ImmutableRetrySignal(this.totalRetries(), this.totalRetriesInARow(), this.failure());
        }
    }
}

