/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.plugin.nlpcn.ComperableHitResult;
import org.elasticsearch.plugin.nlpcn.ElasticHitsExecutor;
import org.elasticsearch.plugin.nlpcn.ElasticUtils;
import org.elasticsearch.plugin.nlpcn.MinusOneFieldAndOptimizationResult;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.domain.Condition;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.domain.hints.Hint;
import org.nlpcn.es4sql.domain.hints.HintType;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.DefaultQueryAction;
import org.nlpcn.es4sql.query.multi.MultiQueryRequestBuilder;

public class MinusExecutor
implements ElasticHitsExecutor {
    private Client client;
    private MultiQueryRequestBuilder builder;
    private SearchHits minusHits;
    private boolean useTermsOptimization;
    private boolean termsOptimizationWithToLower;
    private boolean useScrolling;
    private int maxDocsToFetchOnFirstTable;
    private int maxDocsToFetchOnSecondTable;
    private int maxDocsToFetchOnEachScrollShard;
    private String[] fieldsOrderFirstTable;
    private String[] fieldsOrderSecondTable;
    private String seperator;

    public MinusExecutor(Client client, MultiQueryRequestBuilder builder) {
        this.client = client;
        this.builder = builder;
        this.useTermsOptimization = false;
        this.termsOptimizationWithToLower = false;
        this.useScrolling = false;
        this.parseHintsIfAny(builder.getOriginalSelect(true).getHints());
        this.fillFieldsOrder();
        this.seperator = UUID.randomUUID().toString();
    }

    @Override
    public void run() throws IOException, SqlParseException {
        if (this.useTermsOptimization && this.fieldsOrderFirstTable.length != 1) {
            throw new SqlParseException("terms optimization supports minus with only one field");
        }
        if (this.useTermsOptimization && !this.useScrolling) {
            throw new SqlParseException("terms optimization work only with scrolling add scrolling hint");
        }
        if (!this.useScrolling || !this.useTermsOptimization) {
            Set<ComperableHitResult> comperableHitResults = !this.useScrolling ? this.simpleOneTimeQueryEach() : this.runWithScrollings();
            this.fillMinusHitsFromResults(comperableHitResults);
            return;
        }
        Select firstSelect = this.builder.getOriginalSelect(true);
        MinusOneFieldAndOptimizationResult optimizationResult = this.runWithScrollingAndAddFilter(this.fieldsOrderFirstTable[0], this.fieldsOrderSecondTable[0]);
        String fieldName = this.getFieldName(firstSelect.getFields().get(0));
        Set<Object> results = optimizationResult.getFieldValues();
        SearchHit someHit = optimizationResult.getSomeHit();
        this.fillMinusHitsFromOneField(fieldName, results, someHit);
    }

    @Override
    public SearchHits getHits() {
        return this.minusHits;
    }

    private void fillMinusHitsFromOneField(String fieldName, Set<Object> fieldValues, SearchHit someHit) {
        ArrayList<SearchHit> minusHitsList = new ArrayList<SearchHit>();
        int currentId = 1;
        for (Object result : fieldValues) {
            HashMap<String, DocumentField> fields = new HashMap<String, DocumentField>();
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(result);
            fields.put(fieldName, new DocumentField(fieldName, values));
            SearchHit searchHit = new SearchHit(currentId, currentId + "", new Text(someHit.getType()), fields, null);
            searchHit.sourceRef(someHit.getSourceRef());
            searchHit.getSourceAsMap().clear();
            HashMap<String, Object> sourceAsMap = new HashMap<String, Object>();
            sourceAsMap.put(fieldName, result);
            searchHit.getSourceAsMap().putAll(sourceAsMap);
            ++currentId;
            minusHitsList.add(searchHit);
        }
        int totalSize = currentId - 1;
        SearchHit[] unionHitsArr = minusHitsList.toArray(new SearchHit[totalSize]);
        this.minusHits = new SearchHits(unionHitsArr, new TotalHits((long)totalSize, TotalHits.Relation.EQUAL_TO), 1.0f);
    }

    private void fillMinusHitsFromResults(Set<ComperableHitResult> comperableHitResults) {
        int currentId = 1;
        ArrayList<SearchHit> minusHitsList = new ArrayList<SearchHit>();
        for (ComperableHitResult result : comperableHitResults) {
            ArrayList<ComperableHitResult> values = new ArrayList<ComperableHitResult>();
            values.add(result);
            SearchHit originalHit = result.getOriginalHit();
            SearchHit searchHit = new SearchHit(currentId, originalHit.getId(), new Text(originalHit.getType()), originalHit.getFields(), null);
            searchHit.sourceRef(originalHit.getSourceRef());
            searchHit.getSourceAsMap().clear();
            Map<String, Object> sourceAsMap = result.getFlattenMap();
            for (Map.Entry<String, String> entry : this.builder.getFirstTableFieldToAlias().entrySet()) {
                if (!sourceAsMap.containsKey(entry.getKey())) continue;
                Object value = sourceAsMap.get(entry.getKey());
                sourceAsMap.remove(entry.getKey());
                sourceAsMap.put(entry.getValue(), value);
            }
            searchHit.getSourceAsMap().putAll(sourceAsMap);
            ++currentId;
            minusHitsList.add(searchHit);
        }
        int totalSize = currentId - 1;
        SearchHit[] unionHitsArr = minusHitsList.toArray(new SearchHit[totalSize]);
        this.minusHits = new SearchHits(unionHitsArr, new TotalHits((long)totalSize, TotalHits.Relation.EQUAL_TO), 1.0f);
    }

    private Set<ComperableHitResult> runWithScrollings() {
        SearchResponse scrollResp = ElasticUtils.scrollOneTimeWithHits(this.client, this.builder.getFirstSearchRequest(), this.builder.getOriginalSelect(true), this.maxDocsToFetchOnEachScrollShard);
        HashSet<ComperableHitResult> results = new HashSet<ComperableHitResult>();
        SearchHit[] hits = scrollResp.getHits().getHits();
        if (hits == null || hits.length == 0) {
            return new HashSet<ComperableHitResult>();
        }
        int totalDocsFetchedFromFirstTable = 0;
        while (hits != null && hits.length != 0) {
            this.fillComperableSetFromHits(this.fieldsOrderFirstTable, hits, results);
            if ((totalDocsFetchedFromFirstTable += hits.length) > this.maxDocsToFetchOnFirstTable) break;
            scrollResp = (SearchResponse)this.client.prepareSearchScroll(scrollResp.getScrollId()).setScroll(new TimeValue(600000L)).execute().actionGet();
            hits = scrollResp.getHits().getHits();
        }
        if ((hits = (scrollResp = ElasticUtils.scrollOneTimeWithHits(this.client, this.builder.getSecondSearchRequest(), this.builder.getOriginalSelect(false), this.maxDocsToFetchOnEachScrollShard)).getHits().getHits()) == null || hits.length == 0) {
            return results;
        }
        int totalDocsFetchedFromSecondTable = 0;
        while (hits != null && hits.length != 0) {
            this.removeValuesFromSetAccordingToHits(this.fieldsOrderSecondTable, results, hits);
            if ((totalDocsFetchedFromSecondTable += hits.length) > this.maxDocsToFetchOnSecondTable) break;
            scrollResp = (SearchResponse)this.client.prepareSearchScroll(scrollResp.getScrollId()).setScroll(new TimeValue(600000L)).execute().actionGet();
            hits = scrollResp.getHits().getHits();
        }
        return results;
    }

    private Set<ComperableHitResult> simpleOneTimeQueryEach() {
        SearchHit[] firstTableHits = ((SearchResponse)this.builder.getFirstSearchRequest().get()).getHits().getHits();
        if (firstTableHits == null || firstTableHits.length == 0) {
            return new HashSet<ComperableHitResult>();
        }
        HashSet<ComperableHitResult> result = new HashSet<ComperableHitResult>();
        this.fillComperableSetFromHits(this.fieldsOrderFirstTable, firstTableHits, result);
        SearchHit[] secondTableHits = ((SearchResponse)this.builder.getSecondSearchRequest().get()).getHits().getHits();
        if (secondTableHits == null || secondTableHits.length == 0) {
            return result;
        }
        this.removeValuesFromSetAccordingToHits(this.fieldsOrderSecondTable, result, secondTableHits);
        return result;
    }

    private void removeValuesFromSetAccordingToHits(String[] fieldsOrder, Set<ComperableHitResult> set, SearchHit[] hits) {
        for (SearchHit hit : hits) {
            ComperableHitResult comperableHitResult = new ComperableHitResult(hit, fieldsOrder, this.seperator);
            if (comperableHitResult.isAllNull()) continue;
            set.remove(comperableHitResult);
        }
    }

    private void fillComperableSetFromHits(String[] fieldsOrder, SearchHit[] hits, Set<ComperableHitResult> setToFill) {
        for (SearchHit hit : hits) {
            ComperableHitResult comperableHitResult = new ComperableHitResult(hit, fieldsOrder, this.seperator);
            if (comperableHitResult.isAllNull()) continue;
            setToFill.add(comperableHitResult);
        }
    }

    private String getFieldName(Field field) {
        String alias = field.getAlias();
        if (alias != null && !alias.isEmpty()) {
            return alias;
        }
        return field.getName();
    }

    private boolean checkIfOnlyOneField(Select firstSelect, Select secondSelect) {
        return firstSelect.getFields().size() == 1 && secondSelect.getFields().size() == 1;
    }

    private MinusOneFieldAndOptimizationResult runWithScrollingAndAddFilter(String firstFieldName, String secondFieldName) throws SqlParseException {
        SearchResponse scrollResp = ElasticUtils.scrollOneTimeWithHits(this.client, this.builder.getFirstSearchRequest(), this.builder.getOriginalSelect(true), this.maxDocsToFetchOnEachScrollShard);
        HashSet<Object> results = new HashSet<Object>();
        boolean currentNumOfResults = false;
        SearchHit[] hits = scrollResp.getHits().getHits();
        SearchHit someHit = null;
        if (hits.length != 0) {
            someHit = hits[0];
        }
        int totalDocsFetchedFromFirstTable = 0;
        int totalDocsFetchedFromSecondTable = 0;
        Where originalWhereSecondTable = this.builder.getOriginalSelect(false).getWhere();
        while (hits.length != 0) {
            totalDocsFetchedFromFirstTable += hits.length;
            HashSet<Object> currentSetFromResults = new HashSet<Object>();
            this.fillSetFromHits(firstFieldName, hits, currentSetFromResults);
            Select secondQuerySelect = this.builder.getOriginalSelect(false);
            Where where = this.createWhereWithOrigianlAndTermsFilter(secondFieldName, originalWhereSecondTable, currentSetFromResults);
            secondQuerySelect.setWhere(where);
            DefaultQueryAction queryAction = new DefaultQueryAction(this.client, secondQuerySelect);
            queryAction.explain();
            if (totalDocsFetchedFromSecondTable > this.maxDocsToFetchOnSecondTable) break;
            SearchResponse responseForSecondTable = ElasticUtils.scrollOneTimeWithHits(this.client, queryAction.getRequestBuilder(), secondQuerySelect, this.maxDocsToFetchOnEachScrollShard);
            SearchHits secondQuerySearchHits = responseForSecondTable.getHits();
            SearchHit[] secondQueryHits = secondQuerySearchHits.getHits();
            while (secondQueryHits.length > 0) {
                this.removeValuesFromSetAccordingToHits(secondFieldName, currentSetFromResults, secondQueryHits);
                if ((totalDocsFetchedFromSecondTable += secondQueryHits.length) > this.maxDocsToFetchOnSecondTable) break;
                responseForSecondTable = (SearchResponse)this.client.prepareSearchScroll(responseForSecondTable.getScrollId()).setScroll(new TimeValue(600000L)).execute().actionGet();
                secondQueryHits = responseForSecondTable.getHits().getHits();
            }
            results.addAll(currentSetFromResults);
            if (totalDocsFetchedFromFirstTable > this.maxDocsToFetchOnFirstTable) {
                System.out.println("too many results for first table, stoping at:" + totalDocsFetchedFromFirstTable);
                break;
            }
            scrollResp = (SearchResponse)this.client.prepareSearchScroll(scrollResp.getScrollId()).setScroll(new TimeValue(600000L)).execute().actionGet();
            hits = scrollResp.getHits().getHits();
        }
        return new MinusOneFieldAndOptimizationResult(results, someHit);
    }

    private void removeValuesFromSetAccordingToHits(String fieldName, Set<Object> setToRemoveFrom, SearchHit[] hits) {
        for (SearchHit hit : hits) {
            Object fieldValue = this.getFieldValue(hit, fieldName);
            if (fieldValue == null || !setToRemoveFrom.contains(fieldValue)) continue;
            setToRemoveFrom.remove(fieldValue);
        }
    }

    private void fillSetFromHits(String fieldName, SearchHit[] hits, Set<Object> setToFill) {
        for (SearchHit hit : hits) {
            Object fieldValue = this.getFieldValue(hit, fieldName);
            if (fieldValue == null) continue;
            setToFill.add(fieldValue);
        }
    }

    private Where createWhereWithOrigianlAndTermsFilter(String secondFieldName, Where originalWhereSecondTable, Set<Object> currentSetFromResults) throws SqlParseException {
        Where where = Where.newInstance();
        where.setConn(Where.CONN.AND);
        where.addWhere(originalWhereSecondTable);
        where.addWhere(this.buildTermsFilterFromResults(currentSetFromResults, secondFieldName));
        return where;
    }

    private Where buildTermsFilterFromResults(Set<Object> results, String fieldName) throws SqlParseException {
        return new Condition(Where.CONN.AND, fieldName, null, Condition.OPEAR.IN_TERMS, (Object)results.toArray(), null);
    }

    private Object getFieldValue(SearchHit hit, String fieldName) {
        Map sourceAsMap = hit.getSourceAsMap();
        if (fieldName.contains(".")) {
            String[] split = fieldName.split("\\.");
            return Util.searchPathInMap(sourceAsMap, split);
        }
        if (sourceAsMap.containsKey(fieldName)) {
            return sourceAsMap.get(fieldName);
        }
        return null;
    }

    private void fillFieldsOrder() {
        ArrayList<String> fieldsOrAliases = new ArrayList<String>();
        Map<String, String> firstTableFieldToAlias = this.builder.getFirstTableFieldToAlias();
        List<Field> firstTableFields = this.builder.getOriginalSelect(true).getFields();
        for (Field field : firstTableFields) {
            if (firstTableFieldToAlias.containsKey(field.getName())) {
                fieldsOrAliases.add(field.getAlias());
                continue;
            }
            fieldsOrAliases.add(field.getName());
        }
        Collections.sort(fieldsOrAliases);
        int fieldsSize = fieldsOrAliases.size();
        this.fieldsOrderFirstTable = new String[fieldsSize];
        this.fillFieldsArray(fieldsOrAliases, firstTableFieldToAlias, this.fieldsOrderFirstTable);
        this.fieldsOrderSecondTable = new String[fieldsSize];
        this.fillFieldsArray(fieldsOrAliases, this.builder.getSecondTableFieldToAlias(), this.fieldsOrderSecondTable);
    }

    private void fillFieldsArray(List<String> fieldsOrAliases, Map<String, String> fieldsToAlias, String[] fields) {
        Map<String, String> aliasToField = this.inverseMap(fieldsToAlias);
        for (int i = 0; i < fields.length; ++i) {
            String field = fieldsOrAliases.get(i);
            if (aliasToField.containsKey(field)) {
                field = aliasToField.get(field);
            }
            fields[i] = field;
        }
    }

    private Map<String, String> inverseMap(Map<String, String> mapToInverse) {
        HashMap<String, String> inversedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : mapToInverse.entrySet()) {
            inversedMap.put(entry.getValue(), entry.getKey());
        }
        return inversedMap;
    }

    private void parseHintsIfAny(List<Hint> hints) {
        if (hints == null) {
            return;
        }
        for (Hint hint : hints) {
            Object[] params;
            if (hint.getType() == HintType.MINUS_USE_TERMS_OPTIMIZATION) {
                params = hint.getParams();
                if (params == null || params.length != 1) continue;
                this.termsOptimizationWithToLower = (Boolean)params[0];
                continue;
            }
            if (hint.getType() != HintType.MINUS_FETCH_AND_RESULT_LIMITS) continue;
            params = hint.getParams();
            this.useScrolling = true;
            this.maxDocsToFetchOnFirstTable = (Integer)params[0];
            this.maxDocsToFetchOnSecondTable = (Integer)params[1];
            this.maxDocsToFetchOnEachScrollShard = (Integer)params[2];
        }
    }
}

