/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.util.StringUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.elasticsearch.common.collect.Tuple;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.domain.KVValue;

public class SQLFunctions {
    public static final Set<String> buildInFunctions = Sets.newHashSet((Object[])new String[]{"exp", "log", "log2", "log10", "log10", "sqrt", "cbrt", "ceil", "floor", "rint", "pow", "round", "random", "abs", "split", "concat_ws", "substring", "trim", "add", "multiply", "divide", "subtract", "modulus", "field", "date_format", "if", "max_bw", "min_bw", "coalesce", "case_new"});
    public static Set<String> binaryOperators = Sets.newHashSet((Object[])new String[]{"=", "!=", ">", ">=", "<", "<="});

    public static Tuple<String, String> function(String methodName, List<KVValue> paramers, String name, boolean returnValue, String binaryOperatorName, List<String> binaryOperatorNames) throws Exception {
        if (binaryOperatorName == null || binaryOperatorName.equals("=")) {
            binaryOperatorName = " == ";
        }
        Tuple functionStr = null;
        switch (methodName.toLowerCase()) {
            case "if": {
                String nameIF = "";
                String caseString = "";
                if (paramers.get((int)0).value instanceof SQLInListExpr) {
                    nameIF = nameIF + methodName + "(" + ((SQLInListExpr)paramers.get((int)0).value).getExpr() + " in (";
                    String left = "doc['" + ((SQLInListExpr)paramers.get((int)0).value).getExpr().toString() + "'].value";
                    List targetList = ((SQLInListExpr)paramers.get((int)0).value).getTargetList();
                    for (SQLExpr a : targetList) {
                        caseString = caseString + left + " == '" + a.toString() + "' ||";
                        nameIF = nameIF + a.toString() + ",";
                    }
                    caseString = caseString.substring(0, caseString.length() - 2);
                    nameIF = nameIF.substring(0, nameIF.length() - 1) + "),";
                } else {
                    String key = paramers.get((int)0).key;
                    String left = "doc['" + key + "'].value";
                    String value = paramers.get((int)0).value.toString();
                    caseString = caseString + left + binaryOperatorName + value;
                    nameIF = methodName + "(" + key + binaryOperatorName + value + ",";
                }
                nameIF = nameIF + paramers.get((int)1).value + "," + paramers.get((int)2).value + ")";
                functionStr = new Tuple((Object)nameIF, (Object)("if((" + caseString + ")){" + paramers.get((int)1).value + "} else {" + paramers.get((int)2).value + "}"));
                break;
            }
            case "split": {
                if (paramers.size() == 3) {
                    functionStr = SQLFunctions.split(Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString(), Util.expr2Object((SQLExpr)paramers.get((int)1).value).toString(), Integer.parseInt(Util.expr2Object((SQLExpr)paramers.get((int)2).value).toString()), name);
                    break;
                }
                functionStr = SQLFunctions.split(paramers.get((int)0).value.toString(), paramers.get((int)1).value.toString(), name);
                break;
            }
            case "concat_ws": {
                ArrayList result = Lists.newArrayList();
                for (int i = 1; i < paramers.size(); ++i) {
                    result.add((SQLExpr)paramers.get((int)i).value);
                }
                functionStr = SQLFunctions.concat_ws(paramers.get((int)0).value.toString(), result, name);
                break;
            }
            case "date_format": {
                functionStr = SQLFunctions.date_format(Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString(), Util.expr2Object((SQLExpr)paramers.get((int)1).value).toString(), 2 < paramers.size() ? Util.expr2Object((SQLExpr)paramers.get((int)2).value).toString() : null, name);
                break;
            }
            case "abs": 
            case "round": 
            case "max_bw": 
            case "min_bw": 
            case "coalesce": 
            case "case_new": 
            case "floor": {
                if (paramers.size() >= 2) {
                    if (methodName.equals("round")) {
                        int decimalPrecision = Integer.parseInt(paramers.get((int)1).value.toString());
                        functionStr = SQLFunctions.mathRoundTemplate("Math." + methodName, methodName, Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString(), name, decimalPrecision);
                        break;
                    }
                    if (methodName.equals("max_bw")) {
                        functionStr = SQLFunctions.mathBetweenTemplate("Math.max", methodName, paramers, name);
                        break;
                    }
                    if (methodName.equals("min_bw")) {
                        functionStr = SQLFunctions.mathBetweenTemplate("Math.min", methodName, paramers, name);
                        break;
                    }
                    if (methodName.equals("coalesce")) {
                        functionStr = SQLFunctions.coalesceTemplate(methodName, paramers);
                        break;
                    }
                    if (methodName.equals("case_new")) {
                        functionStr = SQLFunctions.caseNewTemplate(methodName, paramers, binaryOperatorNames);
                        break;
                    }
                }
            }
            case "ceil": 
            case "cbrt": 
            case "rint": 
            case "exp": 
            case "sqrt": {
                functionStr = SQLFunctions.mathSingleValueTemplate("Math." + methodName, methodName, Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString(), name);
                break;
            }
            case "pow": {
                functionStr = SQLFunctions.mathDoubleValueTemplate("Math." + methodName, methodName, Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString(), Util.expr2Object((SQLExpr)paramers.get((int)1).value).toString(), name);
                break;
            }
            case "substring": {
                functionStr = SQLFunctions.substring(Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString(), Integer.parseInt(Util.expr2Object((SQLExpr)paramers.get((int)1).value).toString()), Integer.parseInt(Util.expr2Object((SQLExpr)paramers.get((int)2).value).toString()), name);
                break;
            }
            case "trim": {
                functionStr = SQLFunctions.trim(Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString(), name);
                break;
            }
            case "add": {
                functionStr = SQLFunctions.add((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "subtract": {
                functionStr = SQLFunctions.subtract((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "divide": {
                functionStr = SQLFunctions.divide((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "multiply": {
                functionStr = SQLFunctions.multiply((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "modulus": {
                functionStr = SQLFunctions.modulus((SQLExpr)paramers.get((int)0).value, (SQLExpr)paramers.get((int)1).value);
                break;
            }
            case "field": {
                functionStr = SQLFunctions.field(Util.expr2Object((SQLExpr)paramers.get((int)0).value).toString());
                break;
            }
            case "log2": {
                functionStr = SQLFunctions.log(SQLUtils.toSQLExpr((String)"2"), (SQLExpr)paramers.get((int)0).value, name);
                break;
            }
            case "log10": {
                functionStr = SQLFunctions.log(SQLUtils.toSQLExpr((String)"10"), (SQLExpr)paramers.get((int)0).value, name);
                break;
            }
            case "log": {
                ArrayList logs = Lists.newArrayList();
                for (int i = 0; i < paramers.size(); ++i) {
                    logs.add((SQLExpr)paramers.get((int)0).value);
                }
                if (logs.size() > 1) {
                    functionStr = SQLFunctions.log((SQLExpr)logs.get(0), (SQLExpr)logs.get(1), name);
                    break;
                }
                functionStr = SQLFunctions.log(SQLUtils.toSQLExpr((String)"Math.E"), (SQLExpr)logs.get(0), name);
                break;
            }
        }
        if (returnValue && !methodName.equalsIgnoreCase("if") && !methodName.equalsIgnoreCase("coalesce") && !methodName.equalsIgnoreCase("case_new") && buildInFunctions.contains(methodName)) {
            String generatedFieldName = (String)functionStr.v1();
            String returnCommand = ";return " + generatedFieldName + ";";
            String newScript = (String)functionStr.v2() + returnCommand;
            functionStr = new Tuple((Object)generatedFieldName, (Object)newScript);
        }
        return functionStr;
    }

    public static String random() {
        return Math.abs(new Random().nextInt()) + "";
    }

    private static Tuple<String, String> concat_ws(String split, List<SQLExpr> columns, String valueName) {
        String name = "concat_ws_" + SQLFunctions.random();
        ArrayList result = Lists.newArrayList();
        for (SQLExpr column : columns) {
            String strColumn = Util.expr2Object(column).toString();
            if (strColumn.startsWith("def ")) {
                result.add(strColumn);
                continue;
            }
            if (SQLFunctions.isProperty(column)) {
                result.add("doc['" + strColumn + "'].value");
                continue;
            }
            result.add("'" + strColumn + "'");
        }
        return new Tuple((Object)name, (Object)("def " + name + " =" + Joiner.on((String)("+ " + split + " +")).join((Iterable)result)));
    }

    public static Tuple<String, String> split(String strColumn, String pattern, int index, String valueName) {
        String name = "split_" + SQLFunctions.random();
        String script = "";
        script = valueName == null ? "def " + name + " = doc['" + strColumn + "'].value.split('" + pattern + "')[" + index + "]" : "; def " + name + " = " + valueName + ".split('" + pattern + "')[" + index + "]";
        return new Tuple((Object)name, (Object)script);
    }

    private static Tuple<String, String> date_format(String strColumn, String pattern, String zoneId, String valueName) {
        String name = "date_format_" + SQLFunctions.random();
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = DateTimeFormatter.ofPattern('" + pattern + "').withZone(" + (zoneId != null ? "ZoneId.of('" + zoneId + "')" : "ZoneId.systemDefault()") + ").format(Instant.ofEpochMilli(doc['" + strColumn + "'].value.getMillis()))"));
        }
        return new Tuple((Object)name, (Object)(strColumn + "; def " + name + " = new SimpleDateFormat('" + pattern + "').format(new Date(" + valueName + " - 8*1000*60*60))"));
    }

    public static Tuple<String, String> add(SQLExpr a, SQLExpr b) {
        return SQLFunctions.binaryOpertator("add", "+", a, b);
    }

    private static Tuple<String, String> modulus(SQLExpr a, SQLExpr b) {
        return SQLFunctions.binaryOpertator("modulus", "%", a, b);
    }

    public static Tuple<String, String> field(String a) {
        String name = "field_" + SQLFunctions.random();
        return new Tuple((Object)name, (Object)("def " + name + " = doc['" + a + "'].value"));
    }

    private static Tuple<String, String> subtract(SQLExpr a, SQLExpr b) {
        return SQLFunctions.binaryOpertator("subtract", "-", a, b);
    }

    private static Tuple<String, String> multiply(SQLExpr a, SQLExpr b) {
        return SQLFunctions.binaryOpertator("multiply", "*", a, b);
    }

    private static Tuple<String, String> divide(SQLExpr a, SQLExpr b) {
        return SQLFunctions.binaryOpertator("divide", "/", a, b);
    }

    private static Tuple<String, String> binaryOpertator(String methodName, String operator, SQLExpr a, SQLExpr b) {
        String name = methodName + "_" + SQLFunctions.random();
        return new Tuple((Object)name, (Object)(SQLFunctions.scriptDeclare(a) + SQLFunctions.scriptDeclare(b) + SQLFunctions.convertType(a) + SQLFunctions.convertType(b) + " def " + name + " = " + SQLFunctions.extractName(a) + " " + operator + " " + SQLFunctions.extractName(b)));
    }

    private static boolean isProperty(SQLExpr expr) {
        return expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr || expr instanceof SQLVariantRefExpr;
    }

    private static String scriptDeclare(SQLExpr a) {
        if (SQLFunctions.isProperty(a) || a instanceof SQLNumericLiteralExpr) {
            return "";
        }
        return Util.expr2Object(a).toString() + ";";
    }

    private static String extractName(SQLExpr script) {
        if (SQLFunctions.isProperty(script)) {
            return "doc['" + script + "'].value";
        }
        String scriptStr = Util.expr2Object(script).toString();
        String[] variance = scriptStr.split(";");
        String newScript = variance[variance.length - 1];
        if (newScript.trim().startsWith("def ")) {
            return newScript.trim().substring(4).split("=")[0].trim();
        }
        return scriptStr;
    }

    private static String convertType(SQLExpr script) {
        String[] variance = Util.expr2Object(script).toString().split(";");
        String newScript = variance[variance.length - 1];
        if (newScript.trim().startsWith("def ")) {
            String temp = newScript.trim().substring(4).split("=")[0].trim();
            return " if( " + temp + " instanceof String) " + temp + "= Double.parseDouble(" + temp.trim() + "); ";
        }
        return "";
    }

    public static Tuple<String, String> log(String strColumn, String valueName) {
        return SQLFunctions.mathSingleValueTemplate("log", strColumn, valueName);
    }

    public static Tuple<String, String> log10(String strColumn, String valueName) {
        return SQLFunctions.mathSingleValueTemplate("log10", strColumn, valueName);
    }

    public static Tuple<String, String> log(SQLExpr base, SQLExpr strColumn, String valueName) {
        String name = "log_" + SQLFunctions.random();
        String result = valueName == null ? (SQLFunctions.isProperty(strColumn) ? "def " + name + " = Math.log(doc['" + Util.expr2Object(strColumn).toString() + "'].value)/Math.log(" + Util.expr2Object(base).toString() + ")" : "def " + name + " = Math.log(" + Util.expr2Object(strColumn).toString() + ")/Math.log(" + Util.expr2Object(base).toString() + ")") : Util.expr2Object(strColumn).toString() + ";def " + name + " = Math.log(" + valueName + ")/Math.log(" + Util.expr2Object(base).toString() + ")";
        return new Tuple((Object)name, (Object)result);
    }

    public static Tuple<String, String> sqrt(String strColumn, String valueName) {
        return SQLFunctions.mathSingleValueTemplate("Math.sqrt", "sqrt", strColumn, valueName);
    }

    public static Tuple<String, String> round(String strColumn, String valueName) {
        return SQLFunctions.mathSingleValueTemplate("Math.round", "round", strColumn, valueName);
    }

    public static Tuple<String, String> trim(String strColumn, String valueName) {
        return SQLFunctions.strSingleValueTemplate("trim", strColumn, valueName);
    }

    private static Tuple<String, String> mathDoubleValueTemplate(String methodName, String fieldName, String val1, String val2, String valueName) {
        String name = fieldName + "_" + SQLFunctions.random();
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = " + methodName + "(doc['" + val1 + "'].value, " + val2 + ")"));
        }
        return new Tuple((Object)name, (Object)(val1 + ";def " + name + " = " + methodName + "(" + valueName + ", " + val2 + ")"));
    }

    private static Tuple<String, String> mathSingleValueTemplate(String methodName, String strColumn, String valueName) {
        return SQLFunctions.mathSingleValueTemplate(methodName, methodName, strColumn, valueName);
    }

    private static Tuple<String, String> mathSingleValueTemplate(String methodName, String fieldName, String strColumn, String valueName) {
        String name = fieldName + "_" + SQLFunctions.random();
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = " + methodName + "(doc['" + strColumn + "'].value)"));
        }
        return new Tuple((Object)name, (Object)(strColumn + ";def " + name + " = " + methodName + "(" + valueName + ")"));
    }

    private static Tuple<String, String> mathRoundTemplate(String methodName, String fieldName, String strColumn, String valueName, int decimalPrecision) {
        StringBuilder sb = new StringBuilder("1");
        for (int i = 0; i < decimalPrecision; ++i) {
            sb.append("0");
        }
        double num = Double.parseDouble(sb.toString());
        String name = fieldName + "_" + SQLFunctions.random();
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = " + methodName + "((doc['" + strColumn + "'].value) * " + num + ")/" + num));
        }
        return new Tuple((Object)name, (Object)(strColumn + ";def " + name + " = " + methodName + "((" + valueName + ") * " + num + ")/" + num));
    }

    private static Tuple<String, String> mathBetweenTemplate(String methodName, String fieldName, List<KVValue> paramer, String valueName) {
        String name = fieldName + "_" + SQLFunctions.random();
        StringBuffer sb = new StringBuffer();
        sb.append("def " + name + " = " + methodName + "(");
        int i = 0;
        for (KVValue kv : paramer) {
            String field = kv.value.toString();
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("doc['" + field + "'].value");
            ++i;
        }
        sb.append(")");
        return new Tuple((Object)name, (Object)sb.toString());
    }

    private static Tuple<String, String> coalesceTemplate(String fieldName, List<KVValue> paramer) {
        String name = fieldName + "_" + SQLFunctions.random();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (KVValue kv : paramer) {
            String field = kv.value.toString();
            if (i > 0) {
                sb.append(" else ");
            }
            sb.append("if(doc['" + field + "'].value != null){doc['" + field + "'].value}");
            ++i;
        }
        return new Tuple((Object)name, (Object)sb.toString());
    }

    private static Tuple<String, String> caseNewTemplate(String fieldName, List<KVValue> paramer, List<String> binaryOperatorNames) throws IllegalArgumentException {
        if (paramer.size() % 2 != 0) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570\u6570\u91cf\uff0c\u5fc5\u987b\u662f\u5076\u6570\u4e2a\uff01");
        }
        String defaultVal = null;
        ArrayList<String> fieldList = new ArrayList<String>();
        ArrayList<String> valueList = new ArrayList<String>();
        ArrayList<String> defaultList = new ArrayList<String>();
        for (int i = 0; i < paramer.size(); i += 2) {
            String _default = paramer.get((int)(i + 1)).value.toString();
            if (paramer.get((int)i).value.toString().equalsIgnoreCase("default")) {
                defaultVal = _default;
                continue;
            }
            fieldList.add(paramer.get((int)i).key);
            valueList.add(paramer.get((int)i).value.toString());
            defaultList.add(_default);
        }
        String name = fieldName + "_" + SQLFunctions.random();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (int j = 0; j < fieldList.size(); ++j) {
            String binaryOperatorName;
            String field = (String)fieldList.get(j);
            if (i > 0) {
                sb.append(" else ");
            }
            if ("=".equals(binaryOperatorName = binaryOperatorNames.get(j))) {
                binaryOperatorName = "==";
            }
            sb.append("if(doc['" + field + "'].value " + binaryOperatorName + " " + valueList.get(i) + ") { " + defaultList.get(i) + " }");
            ++i;
        }
        if (!StringUtils.isEmpty((String)defaultVal)) {
            sb.append(" else " + defaultVal);
        }
        return new Tuple((Object)name, (Object)sb.toString());
    }

    public static Tuple<String, String> strSingleValueTemplate(String methodName, String strColumn, String valueName) {
        String name = methodName + "_" + SQLFunctions.random();
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = doc['" + strColumn + "'].value." + methodName + "()"));
        }
        return new Tuple((Object)name, (Object)(strColumn + "; def " + name + " = " + valueName + "." + methodName + "()"));
    }

    public static Tuple<String, String> floor(String strColumn, String valueName) {
        return SQLFunctions.mathSingleValueTemplate("Math.floor", "floor", strColumn, valueName);
    }

    public static Tuple<String, String> substring(String strColumn, int pos, int len, String valueName) {
        String name = "substring_" + SQLFunctions.random();
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = doc['" + strColumn + "'].value.substring(" + pos + "," + len + ")"));
        }
        return new Tuple((Object)name, (Object)(strColumn + ";def " + name + " = " + valueName + ".substring(" + pos + "," + len + ")"));
    }

    public static Tuple<String, String> split(String strColumn, String pattern, String valueName) {
        String name = "split_" + SQLFunctions.random();
        if (valueName == null) {
            return new Tuple((Object)name, (Object)("def " + name + " = doc['" + strColumn + "'].value.split('" + pattern + "')"));
        }
        return new Tuple((Object)name, (Object)(strColumn + "; def " + name + " = " + valueName + ".split('" + pattern + "')"));
    }
}

