/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.parse;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLTextLiteralExpr;
import java.util.List;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.SqlParser;
import org.nlpcn.es4sql.parse.WhereParser;

public class ChildrenType {
    public String field;
    public String childType;
    public Where where;
    private boolean simple;

    public boolean tryFillFromExpr(SQLExpr expr) throws SqlParseException {
        String type;
        if (!(expr instanceof SQLMethodInvokeExpr)) {
            return false;
        }
        SQLMethodInvokeExpr method = (SQLMethodInvokeExpr)expr;
        String methodName = method.getMethodName();
        if (!methodName.toLowerCase().equals("children")) {
            return false;
        }
        List parameters = method.getParameters();
        if (parameters.size() != 2) {
            throw new SqlParseException("on children object only allowed 2 parameters (type, field)/(type, conditions...) ");
        }
        this.childType = type = Util.extendedToString((SQLExpr)parameters.get(0));
        SQLExpr secondParameter = (SQLExpr)parameters.get(1);
        if (secondParameter instanceof SQLTextLiteralExpr || secondParameter instanceof SQLIdentifierExpr || secondParameter instanceof SQLPropertyExpr) {
            this.field = Util.extendedToString(secondParameter);
            this.simple = true;
        } else {
            Where where = Where.newInstance();
            new WhereParser(new SqlParser()).parseWhere(secondParameter, where);
            if (where.getWheres().size() == 0) {
                throw new SqlParseException("unable to parse filter where.");
            }
            this.where = where;
            this.simple = false;
        }
        return true;
    }

    public boolean isSimple() {
        return this.simple;
    }
}

