/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.parse;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLTextLiteralExpr;
import java.util.List;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.SqlParser;
import org.nlpcn.es4sql.parse.WhereParser;

public class NestedType {
    public String field;
    public String path;
    public Where where;
    private boolean reverse;
    private boolean simple;
    private String innerHits;

    public boolean tryFillFromExpr(SQLExpr expr) throws SqlParseException {
        String field;
        if (!(expr instanceof SQLMethodInvokeExpr)) {
            return false;
        }
        SQLMethodInvokeExpr method = (SQLMethodInvokeExpr)expr;
        String methodNameLower = method.getMethodName().toLowerCase();
        if (!methodNameLower.equals("nested") && !methodNameLower.equals("reverse_nested")) {
            return false;
        }
        this.reverse = methodNameLower.equals("reverse_nested");
        List parameters = method.getParameters();
        int size = parameters.size();
        if (size != 3 && size != 2 && size != 1) {
            throw new SqlParseException("on nested object only allowed 3 parameters (path,conditions..,inner_hits) or 2 parameters (field,path)/(path,conditions..) or 1 parameter (field) ");
        }
        if (size == 3) {
            this.innerHits = Util.extendedToString((SQLExpr)parameters.remove(--size));
        }
        this.field = field = Util.extendedToString((SQLExpr)parameters.get(0));
        if (size == 1) {
            if (!field.contains(".")) {
                if (!this.reverse) {
                    throw new SqlParseException("nested should contain . on their field name");
                }
                this.path = null;
                this.simple = true;
            } else {
                int lastDot = field.lastIndexOf(".");
                this.path = field.substring(0, lastDot);
                this.simple = true;
            }
        } else if (size == 2) {
            SQLExpr secondParameter = (SQLExpr)parameters.get(1);
            if (secondParameter instanceof SQLTextLiteralExpr || secondParameter instanceof SQLIdentifierExpr || secondParameter instanceof SQLPropertyExpr) {
                String pathString = Util.extendedToString(secondParameter);
                this.path = pathString.equals("") ? null : pathString;
                this.simple = true;
            } else {
                this.path = field;
                Where where = Where.newInstance();
                new WhereParser(new SqlParser()).parseWhere(secondParameter, where);
                if (where.getWheres().size() == 0) {
                    throw new SqlParseException("unable to parse filter where.");
                }
                this.where = where;
                this.simple = false;
            }
        }
        return true;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public String getInnerHits() {
        return this.innerHits;
    }

    public void setInnerHits(String innerHits) {
        this.innerHits = innerHits;
    }
}

