/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.parse;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLTextLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nlpcn.es4sql.SQLFunctions;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.domain.Condition;
import org.nlpcn.es4sql.domain.KVValue;
import org.nlpcn.es4sql.domain.MethodField;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.ChildrenType;
import org.nlpcn.es4sql.parse.FieldMaker;
import org.nlpcn.es4sql.parse.NestedType;
import org.nlpcn.es4sql.parse.ScriptFilter;
import org.nlpcn.es4sql.parse.SqlParser;
import org.nlpcn.es4sql.parse.SubQueryExpression;
import org.nlpcn.es4sql.spatial.SpatialParamsFactory;

public class WhereParser {
    private MySqlSelectQueryBlock query;
    private SQLDeleteStatement delete;
    private SQLExpr where;
    private SqlParser sqlParser;

    public WhereParser(SqlParser sqlParser, MySqlSelectQueryBlock query) {
        this.sqlParser = sqlParser;
        this.query = query;
        this.where = query.getWhere();
    }

    public WhereParser(SqlParser sqlParser, SQLDeleteStatement delete) {
        this.sqlParser = sqlParser;
        this.delete = delete;
        this.where = delete.getWhere();
    }

    public WhereParser(SqlParser sqlParser, SQLExpr expr) {
        this.sqlParser = sqlParser;
        this.where = expr;
    }

    public WhereParser(SqlParser sqlParser) {
        this.sqlParser = sqlParser;
    }

    public Where findWhere() throws SqlParseException {
        if (this.where == null) {
            return null;
        }
        Where myWhere = Where.newInstance();
        this.parseWhere(this.where, myWhere);
        return myWhere;
    }

    public void parseWhere(SQLExpr expr, Where where) throws SqlParseException {
        SQLBinaryOpExpr bExpr;
        if (expr instanceof SQLBinaryOpExpr) {
            bExpr = (SQLBinaryOpExpr)expr;
            if (this.explanSpecialCondWithBothSidesAreLiterals(bExpr, where)) {
                return;
            }
            if (this.explanSpecialCondWithBothSidesAreProperty(bExpr, where)) {
                return;
            }
        }
        if (expr instanceof SQLBinaryOpExpr && !this.isCond((SQLBinaryOpExpr)expr)) {
            bExpr = (SQLBinaryOpExpr)expr;
            this.routeCond(bExpr, bExpr.getLeft(), where);
            this.routeCond(bExpr, bExpr.getRight(), where);
        } else if (expr instanceof SQLNotExpr) {
            this.parseWhere(((SQLNotExpr)expr).getExpr(), where);
            this.negateWhere(where);
        } else {
            this.explanCond("AND", expr, where);
        }
    }

    private void negateWhere(Where where) throws SqlParseException {
        for (Where sub : where.getWheres()) {
            if (sub instanceof Condition) {
                Condition cond = (Condition)sub;
                cond.setOpear(cond.getOpear().negative());
            } else {
                this.negateWhere(sub);
            }
            sub.setConn(sub.getConn().negative());
        }
    }

    private boolean explanSpecialCondWithBothSidesAreLiterals(SQLBinaryOpExpr bExpr, Where where) throws SqlParseException {
        if ((bExpr.getLeft() instanceof SQLNumericLiteralExpr || bExpr.getLeft() instanceof SQLCharExpr) && (bExpr.getRight() instanceof SQLNumericLiteralExpr || bExpr.getRight() instanceof SQLCharExpr)) {
            SQLMethodInvokeExpr sqlMethodInvokeExpr = new SQLMethodInvokeExpr("script", null);
            String operator = bExpr.getOperator().getName();
            if (operator.equals("=")) {
                operator = "==";
            }
            sqlMethodInvokeExpr.addParameter((SQLExpr)new SQLCharExpr(Util.expr2Object(bExpr.getLeft(), "'") + " " + operator + " " + Util.expr2Object(bExpr.getRight(), "'")));
            this.explanCond("AND", (SQLExpr)sqlMethodInvokeExpr, where);
            return true;
        }
        return false;
    }

    private boolean explanSpecialCondWithBothSidesAreProperty(SQLBinaryOpExpr bExpr, Where where) throws SqlParseException {
        if ((bExpr.getLeft() instanceof SQLPropertyExpr || bExpr.getLeft() instanceof SQLIdentifierExpr) && (bExpr.getRight() instanceof SQLPropertyExpr || bExpr.getRight() instanceof SQLIdentifierExpr) && Sets.newHashSet((Object[])new String[]{"=", "<", ">", ">=", "<=", "<>", "!="}).contains(bExpr.getOperator().getName()) && !Util.isFromJoinOrUnionTable((SQLExpr)bExpr)) {
            SQLMethodInvokeExpr sqlMethodInvokeExpr = new SQLMethodInvokeExpr("script", null);
            String operator = bExpr.getOperator().getName();
            if (operator.equals("=")) {
                operator = "==";
            } else if (operator.equals("<>")) {
                operator = "!=";
            }
            String leftProperty = Util.expr2Object(bExpr.getLeft()).toString();
            String rightProperty = Util.expr2Object(bExpr.getRight()).toString();
            if (leftProperty.split("\\.").length > 1) {
                leftProperty = leftProperty.substring(leftProperty.split("\\.")[0].length() + 1);
            }
            if (rightProperty.split("\\.").length > 1) {
                rightProperty = rightProperty.substring(rightProperty.split("\\.")[0].length() + 1);
            }
            sqlMethodInvokeExpr.addParameter((SQLExpr)new SQLCharExpr("doc['" + leftProperty + "'].value " + operator + " doc['" + rightProperty + "'].value"));
            this.explanCond("AND", (SQLExpr)sqlMethodInvokeExpr, where);
            return true;
        }
        return false;
    }

    private boolean isCond(SQLBinaryOpExpr expr) {
        SQLExpr leftSide = expr.getLeft();
        if (leftSide instanceof SQLMethodInvokeExpr) {
            return this.isAllowedMethodOnConditionLeft((SQLMethodInvokeExpr)leftSide, expr.getOperator());
        }
        return leftSide instanceof SQLIdentifierExpr || leftSide instanceof SQLPropertyExpr || leftSide instanceof SQLVariantRefExpr || leftSide instanceof SQLCastExpr;
    }

    private boolean isAllowedMethodOnConditionLeft(SQLMethodInvokeExpr method, SQLBinaryOperator operator) {
        return (method.getMethodName().toLowerCase().equals("nested") || method.getMethodName().toLowerCase().equals("children") || SQLFunctions.buildInFunctions.contains(method.getMethodName().toLowerCase())) && !operator.isLogical();
    }

    private void routeCond(SQLBinaryOpExpr bExpr, SQLExpr sub, Where where) throws SqlParseException {
        if (sub instanceof SQLBinaryOpExpr && (!this.isCond((SQLBinaryOpExpr)sub) || ((SQLBinaryOpExpr)sub).getLeft() instanceof SQLIdentifierExpr && ((SQLBinaryOpExpr)sub).getRight() instanceof SQLIdentifierExpr)) {
            SQLBinaryOpExpr binarySub = (SQLBinaryOpExpr)sub;
            if (binarySub.getOperator().priority != bExpr.getOperator().priority) {
                Where subWhere = new Where(bExpr.getOperator().name);
                where.addWhere(subWhere);
                this.parseWhere((SQLExpr)binarySub, subWhere);
            } else {
                this.parseWhere((SQLExpr)binarySub, where);
            }
        } else if (sub instanceof SQLNotExpr) {
            Where subWhere = new Where(bExpr.getOperator().name);
            where.addWhere(subWhere);
            this.parseWhere(((SQLNotExpr)sub).getExpr(), subWhere);
            this.negateWhere(subWhere);
        } else {
            this.explanCond(bExpr.getOperator().name, sub, where);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void explanCond(String opear, SQLExpr expr, Where where) throws SqlParseException {
        if (expr instanceof SQLBinaryOpExpr) {
            SQLMethodInvokeExpr method;
            String methodName;
            ChildrenType childrenType;
            SQLBinaryOpExpr soExpr = (SQLBinaryOpExpr)expr;
            if (this.explanSpecialCondWithBothSidesAreLiterals(soExpr, where)) {
                return;
            }
            if (this.explanSpecialCondWithBothSidesAreProperty(soExpr, where)) {
                return;
            }
            boolean methodAsOpear = false;
            boolean isNested = false;
            boolean isChildren = false;
            NestedType nestedType = new NestedType();
            if (nestedType.tryFillFromExpr(soExpr.getLeft())) {
                soExpr.setLeft((SQLExpr)new SQLIdentifierExpr(nestedType.field));
                isNested = true;
            }
            if ((childrenType = new ChildrenType()).tryFillFromExpr(soExpr.getLeft())) {
                soExpr.setLeft((SQLExpr)new SQLIdentifierExpr(childrenType.field));
                isChildren = true;
            }
            if (soExpr.getRight() instanceof SQLMethodInvokeExpr && Condition.OPEAR.methodNameToOpear.containsKey(methodName = (method = (SQLMethodInvokeExpr)soExpr.getRight()).getMethodName().toLowerCase())) {
                Object[] methodParametersValue = this.getMethodValuesWithSubQueries(method);
                Condition condition = null;
                Condition.OPEAR oper = Condition.OPEAR.methodNameToOpear.get(methodName);
                if (soExpr.getOperator() == SQLBinaryOperator.LessThanOrGreater || soExpr.getOperator() == SQLBinaryOperator.NotEqual) {
                    oper = oper.negative();
                }
                condition = isNested ? new Condition(Where.CONN.valueOf(opear), soExpr.getLeft().toString(), soExpr.getLeft(), oper, (Object)methodParametersValue, soExpr.getRight(), (Object)nestedType) : (isChildren ? new Condition(Where.CONN.valueOf(opear), soExpr.getLeft().toString(), soExpr.getLeft(), oper, (Object)methodParametersValue, soExpr.getRight(), (Object)childrenType) : new Condition(Where.CONN.valueOf(opear), soExpr.getLeft().toString(), soExpr.getLeft(), oper, (Object)methodParametersValue, soExpr.getRight(), null));
                where.addWhere(condition);
                return;
            }
            if (methodAsOpear) return;
            Condition condition = null;
            if (isNested) {
                condition = new Condition(Where.CONN.valueOf(opear), soExpr.getLeft().toString(), soExpr.getLeft(), soExpr.getOperator().name, this.parseValue(soExpr.getRight()), soExpr.getRight(), (Object)nestedType);
            } else if (isChildren) {
                condition = new Condition(Where.CONN.valueOf(opear), soExpr.getLeft().toString(), soExpr.getLeft(), soExpr.getOperator().name, this.parseValue(soExpr.getRight()), soExpr.getRight(), (Object)childrenType);
            } else {
                SQLMethodInvokeExpr sqlMethodInvokeExpr = this.parseSQLBinaryOpExprWhoIsConditionInWhere(soExpr);
                if (sqlMethodInvokeExpr == null) {
                    condition = new Condition(Where.CONN.valueOf(opear), soExpr.getLeft().toString(), soExpr.getLeft(), soExpr.getOperator().name, this.parseValue(soExpr.getRight()), soExpr.getRight(), null);
                } else {
                    ScriptFilter scriptFilter = new ScriptFilter();
                    if (!scriptFilter.tryParseFromMethodExpr(sqlMethodInvokeExpr)) {
                        throw new SqlParseException("could not parse script filter");
                    }
                    condition = new Condition(Where.CONN.valueOf(opear), null, null, "SCRIPT", (Object)scriptFilter, null);
                }
            }
            where.addWhere(condition);
            return;
        } else if (expr instanceof SQLInListExpr) {
            ChildrenType childrenType;
            SQLInListExpr siExpr = (SQLInListExpr)expr;
            String leftSide = siExpr.getExpr().toString();
            boolean isNested = false;
            boolean isChildren = false;
            NestedType nestedType = new NestedType();
            if (nestedType.tryFillFromExpr(siExpr.getExpr())) {
                leftSide = nestedType.field;
                isNested = false;
            }
            if ((childrenType = new ChildrenType()).tryFillFromExpr(siExpr.getExpr())) {
                leftSide = childrenType.field;
                isChildren = true;
            }
            Condition condition = null;
            condition = isNested ? new Condition(Where.CONN.valueOf(opear), leftSide, null, siExpr.isNot() ? "NOT IN" : "IN", (Object)this.parseValue(siExpr.getTargetList()), null, (Object)nestedType) : (isChildren ? new Condition(Where.CONN.valueOf(opear), leftSide, null, siExpr.isNot() ? "NOT IN" : "IN", (Object)this.parseValue(siExpr.getTargetList()), null, (Object)childrenType) : (siExpr.getExpr() instanceof SQLCaseExpr ? new Condition(Where.CONN.valueOf(opear), leftSide, siExpr.getExpr(), siExpr.isNot() ? "NOT IN" : "IN", (Object)this.parseValue(siExpr.getTargetList()), null) : new Condition(Where.CONN.valueOf(opear), leftSide, null, siExpr.isNot() ? "NOT IN" : "IN", (Object)this.parseValue(siExpr.getTargetList()), null)));
            where.addWhere(condition);
            return;
        } else if (expr instanceof SQLBetweenExpr) {
            ChildrenType childrenType;
            SQLBetweenExpr between = (SQLBetweenExpr)expr;
            String leftSide = between.getTestExpr().toString();
            boolean isNested = false;
            boolean isChildren = false;
            NestedType nestedType = new NestedType();
            if (nestedType.tryFillFromExpr(between.getTestExpr())) {
                leftSide = nestedType.field;
                isNested = true;
            }
            if ((childrenType = new ChildrenType()).tryFillFromExpr(between.getTestExpr())) {
                leftSide = childrenType.field;
                isChildren = true;
            }
            Condition condition = null;
            condition = isNested ? new Condition(Where.CONN.valueOf(opear), leftSide, null, between.isNot() ? "NOT BETWEEN" : "BETWEEN", (Object)new Object[]{this.parseValue(between.beginExpr), this.parseValue(between.endExpr)}, null, (Object)nestedType) : (isChildren ? new Condition(Where.CONN.valueOf(opear), leftSide, null, between.isNot() ? "NOT BETWEEN" : "BETWEEN", (Object)new Object[]{this.parseValue(between.beginExpr), this.parseValue(between.endExpr)}, null, (Object)childrenType) : new Condition(Where.CONN.valueOf(opear), leftSide, null, between.isNot() ? "NOT BETWEEN" : "BETWEEN", (Object)new Object[]{this.parseValue(between.beginExpr), this.parseValue(between.endExpr)}, null, null));
            where.addWhere(condition);
            return;
        } else if (expr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr methodExpr = (SQLMethodInvokeExpr)expr;
            List methodParameters = methodExpr.getParameters();
            String methodName = methodExpr.getMethodName();
            if (SpatialParamsFactory.isAllowedMethod(methodName)) {
                ChildrenType childrenType;
                String fieldName = ((SQLExpr)methodParameters.get(0)).toString();
                boolean isNested = false;
                boolean isChildren = false;
                NestedType nestedType = new NestedType();
                if (nestedType.tryFillFromExpr((SQLExpr)methodParameters.get(0))) {
                    fieldName = nestedType.field;
                    isNested = true;
                }
                if ((childrenType = new ChildrenType()).tryFillFromExpr((SQLExpr)methodParameters.get(0))) {
                    fieldName = childrenType.field;
                    isChildren = true;
                }
                Object spatialParamsObject = SpatialParamsFactory.generateSpatialParamsObject(methodName, methodParameters);
                Condition condition = null;
                condition = isNested ? new Condition(Where.CONN.valueOf(opear), fieldName, null, methodName, spatialParamsObject, null, (Object)nestedType) : (isChildren ? new Condition(Where.CONN.valueOf(opear), fieldName, null, methodName, spatialParamsObject, null, (Object)childrenType) : new Condition(Where.CONN.valueOf(opear), fieldName, null, methodName, spatialParamsObject, null, null));
                where.addWhere(condition);
                return;
            } else if (methodName.toLowerCase().equals("nested")) {
                NestedType nestedType = new NestedType();
                if (!nestedType.tryFillFromExpr(expr)) {
                    throw new SqlParseException("could not fill nested from expr:" + expr);
                }
                Condition condition = new Condition(Where.CONN.valueOf(opear), nestedType.path, null, methodName.toUpperCase(), (Object)nestedType.where, null, (Object)nestedType);
                where.addWhere(condition);
                return;
            } else if (methodName.toLowerCase().equals("children")) {
                ChildrenType childrenType = new ChildrenType();
                if (!childrenType.tryFillFromExpr(expr)) {
                    throw new SqlParseException("could not fill children from expr:" + expr);
                }
                Condition condition = new Condition(Where.CONN.valueOf(opear), childrenType.childType, null, methodName.toUpperCase(), (Object)childrenType.where, null);
                where.addWhere(condition);
                return;
            } else {
                if (!methodName.toLowerCase().equals("script")) throw new SqlParseException("unsupported method: " + methodName);
                ScriptFilter scriptFilter = new ScriptFilter();
                if (!scriptFilter.tryParseFromMethodExpr(methodExpr)) {
                    throw new SqlParseException("could not parse script filter");
                }
                Condition condition = new Condition(Where.CONN.valueOf(opear), null, null, "SCRIPT", (Object)scriptFilter, null);
                where.addWhere(condition);
            }
            return;
        } else {
            ChildrenType childrenType;
            if (!(expr instanceof SQLInSubQueryExpr)) throw new SqlParseException("err find condition " + expr.getClass());
            SQLInSubQueryExpr sqlIn = (SQLInSubQueryExpr)expr;
            Select innerSelect = this.sqlParser.parseSelect((MySqlSelectQueryBlock)sqlIn.getSubQuery().getQuery());
            if (innerSelect.getFields() == null) throw new SqlParseException("should only have one return field in subQuery");
            if (innerSelect.getFields().size() != 1) {
                throw new SqlParseException("should only have one return field in subQuery");
            }
            SubQueryExpression subQueryExpression = new SubQueryExpression(innerSelect);
            String leftSide = sqlIn.getExpr().toString();
            boolean isNested = false;
            boolean isChildren = false;
            NestedType nestedType = new NestedType();
            if (nestedType.tryFillFromExpr(sqlIn.getExpr())) {
                leftSide = nestedType.field;
                isNested = true;
            }
            if ((childrenType = new ChildrenType()).tryFillFromExpr(sqlIn.getExpr())) {
                leftSide = childrenType.field;
                isChildren = true;
            }
            Condition condition = null;
            condition = isNested ? new Condition(Where.CONN.valueOf(opear), leftSide, null, sqlIn.isNot() ? "NOT IN" : "IN", (Object)subQueryExpression, null, (Object)nestedType) : (isChildren ? new Condition(Where.CONN.valueOf(opear), leftSide, null, sqlIn.isNot() ? "NOT IN" : "IN", (Object)subQueryExpression, null, (Object)childrenType) : new Condition(Where.CONN.valueOf(opear), leftSide, null, sqlIn.isNot() ? "NOT IN" : "IN", (Object)subQueryExpression, null, null));
            where.addWhere(condition);
        }
    }

    private MethodField parseSQLMethodInvokeExprWithFunctionInWhere(SQLMethodInvokeExpr soExpr) throws SqlParseException {
        MethodField methodField = FieldMaker.makeMethodField(soExpr.getMethodName(), soExpr.getParameters(), null, null, this.query != null ? this.query.getFrom().getAlias() : null, false);
        return methodField;
    }

    private MethodField parseSQLCastExprInWhere(SQLCastExpr soExpr) throws SqlParseException {
        MethodField methodField = FieldMaker.makeMethodField("cast", Collections.singletonList(soExpr), null, null, this.query != null ? this.query.getFrom().getAlias() : null, true);
        List<KVValue> params = methodField.getParams();
        KVValue param = params.get(0);
        params.clear();
        params.add(new KVValue(param.key));
        params.add(new KVValue(param.value));
        return methodField;
    }

    private SQLMethodInvokeExpr parseSQLBinaryOpExprWhoIsConditionInWhere(SQLBinaryOpExpr soExpr) throws SqlParseException {
        if (!(soExpr.getLeft() instanceof SQLCastExpr) && !(soExpr.getRight() instanceof SQLCastExpr)) {
            if (!(soExpr.getLeft() instanceof SQLMethodInvokeExpr) && !(soExpr.getRight() instanceof SQLMethodInvokeExpr)) {
                return null;
            }
            if (soExpr.getLeft() instanceof SQLMethodInvokeExpr && !SQLFunctions.buildInFunctions.contains(((SQLMethodInvokeExpr)soExpr.getLeft()).getMethodName())) {
                return null;
            }
            if (soExpr.getRight() instanceof SQLMethodInvokeExpr && !SQLFunctions.buildInFunctions.contains(((SQLMethodInvokeExpr)soExpr.getRight()).getMethodName())) {
                return null;
            }
        }
        MethodField leftMethod = new MethodField(null, Lists.newArrayList((Object[])new KVValue[]{new KVValue("", Util.expr2Object(soExpr.getLeft(), "'"))}), null, null);
        if (soExpr.getLeft() instanceof SQLIdentifierExpr || soExpr.getLeft() instanceof SQLPropertyExpr) {
            leftMethod = new MethodField(null, Lists.newArrayList((Object[])new KVValue[]{new KVValue("", "doc['" + Util.expr2Object(soExpr.getLeft(), "'") + "'].value")}), null, null);
        } else if (soExpr.getLeft() instanceof SQLMethodInvokeExpr) {
            leftMethod = this.parseSQLMethodInvokeExprWithFunctionInWhere((SQLMethodInvokeExpr)soExpr.getLeft());
        } else if (soExpr.getLeft() instanceof SQLCastExpr) {
            leftMethod = this.parseSQLCastExprInWhere((SQLCastExpr)soExpr.getLeft());
        }
        MethodField rightMethod = new MethodField(null, Lists.newArrayList((Object[])new KVValue[]{new KVValue("", Util.expr2Object(soExpr.getRight(), "'"))}), null, null);
        if (soExpr.getRight() instanceof SQLIdentifierExpr || soExpr.getRight() instanceof SQLPropertyExpr) {
            rightMethod = new MethodField(null, Lists.newArrayList((Object[])new KVValue[]{new KVValue("", "doc['" + Util.expr2Object(soExpr.getRight(), "'") + "'].value")}), null, null);
        } else if (soExpr.getRight() instanceof SQLMethodInvokeExpr) {
            rightMethod = this.parseSQLMethodInvokeExprWithFunctionInWhere((SQLMethodInvokeExpr)soExpr.getRight());
        } else if (soExpr.getRight() instanceof SQLCastExpr) {
            rightMethod = this.parseSQLCastExprInWhere((SQLCastExpr)soExpr.getRight());
        }
        String v1 = leftMethod.getParams().get((int)0).value.toString();
        String v1Dec = leftMethod.getParams().size() == 2 ? leftMethod.getParams().get((int)1).value.toString() + ";" : "";
        String v2 = rightMethod.getParams().get((int)0).value.toString();
        String v2Dec = rightMethod.getParams().size() == 2 ? rightMethod.getParams().get((int)1).value.toString() + ";" : "";
        String operator = soExpr.getOperator().getName();
        if ("=".equals(operator)) {
            operator = "==";
        }
        String finalStr = String.format("%s%s((Comparable)%s).compareTo(%s) %s 0", v1Dec, v2Dec, v1, v2, operator);
        SQLMethodInvokeExpr scriptMethod = new SQLMethodInvokeExpr("script", null);
        scriptMethod.addParameter((SQLExpr)new SQLCharExpr(finalStr));
        return scriptMethod;
    }

    private Object[] getMethodValuesWithSubQueries(SQLMethodInvokeExpr method) throws SqlParseException {
        ArrayList<Object> values = new ArrayList<Object>();
        for (SQLExpr innerExpr : method.getParameters()) {
            if (innerExpr instanceof SQLQueryExpr) {
                Select select = this.sqlParser.parseSelect((MySqlSelectQueryBlock)((SQLQueryExpr)innerExpr).getSubQuery().getQuery());
                values.add(new SubQueryExpression(select));
                continue;
            }
            if (innerExpr instanceof SQLTextLiteralExpr) {
                values.add(((SQLTextLiteralExpr)innerExpr).getText());
                continue;
            }
            values.add(innerExpr);
        }
        return values.toArray();
    }

    private Object[] parseValue(List<SQLExpr> targetList) throws SqlParseException {
        Object[] value = new Object[targetList.size()];
        for (int i = 0; i < targetList.size(); ++i) {
            value[i] = this.parseValue(targetList.get(i));
        }
        return value;
    }

    private Object parseValue(SQLExpr expr) throws SqlParseException {
        if (expr instanceof SQLNumericLiteralExpr) {
            Number number = ((SQLNumericLiteralExpr)expr).getNumber();
            if (number instanceof BigDecimal) {
                return number.doubleValue();
            }
            if (number instanceof BigInteger) {
                return number.longValue();
            }
            return ((SQLNumericLiteralExpr)expr).getNumber();
        }
        if (expr instanceof SQLCharExpr) {
            return ((SQLCharExpr)expr).getText();
        }
        if (expr instanceof SQLMethodInvokeExpr) {
            return expr;
        }
        if (expr instanceof SQLNullExpr) {
            return null;
        }
        if (expr instanceof SQLIdentifierExpr) {
            return expr;
        }
        if (expr instanceof SQLPropertyExpr) {
            return expr;
        }
        throw new SqlParseException(String.format("Failed to parse SqlExpression of type %s. expression value: %s", expr.getClass(), expr));
    }
}

