/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.composite;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.composite.CompositeDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest
public class CompositeDiscoveryClientAutoConfigurationTests {
    @Autowired
    private DiscoveryClient discoveryClient;

    @Test
    public void compositeDiscoveryClientShouldBeTheDefault() {
        Assertions.assertThat((Object)this.discoveryClient).isInstanceOf(CompositeDiscoveryClient.class);
        CompositeDiscoveryClient compositeDiscoveryClient = (CompositeDiscoveryClient)this.discoveryClient;
        Assertions.assertThat((List)compositeDiscoveryClient.getDiscoveryClients()).hasSize(2);
        Assertions.assertThat((String)((DiscoveryClient)compositeDiscoveryClient.getDiscoveryClients().get(0)).description()).isEqualTo((Object)"A custom discovery client");
    }

    @Test
    public void simpleDiscoveryClientShouldBeHaveTheLowestPrecedence() {
        CompositeDiscoveryClient compositeDiscoveryClient = (CompositeDiscoveryClient)this.discoveryClient;
        Assertions.assertThat((String)((DiscoveryClient)compositeDiscoveryClient.getDiscoveryClients().get(0)).description()).isEqualTo((Object)"A custom discovery client");
        Assertions.assertThat(compositeDiscoveryClient.getDiscoveryClients().get(1)).isInstanceOf(SimpleDiscoveryClient.class);
    }

    @EnableAutoConfiguration
    @Configuration
    public static class Config {
        @Bean
        public DiscoveryClient customDiscoveryClient1() {
            return new DiscoveryClient(){

                public String description() {
                    return "A custom discovery client";
                }

                public ServiceInstance getLocalServiceInstance() {
                    return null;
                }

                public List<ServiceInstance> getInstances(String serviceId) {
                    return null;
                }

                public List<String> getServices() {
                    return null;
                }
            };
        }
    }
}

