/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple;

import java.net.URI;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(properties={"spring.application.name=service0", "spring.cloud.discovery.client.simple.instances.service1[0].uri=http://s1-1:8080", "spring.cloud.discovery.client.simple.instances.service1[1].uri=https://s1-2:8443", "spring.cloud.discovery.client.simple.instances.service2[0].uri=https://s2-1:8080", "spring.cloud.discovery.client.simple.instances.service2[1].uri=https://s2-2:443"})
public class SimpleDiscoveryClientPropertiesMappingTests {
    @Autowired
    private SimpleDiscoveryProperties props;
    @Autowired
    private SimpleDiscoveryClient discoveryClient;

    @Test
    public void propsShouldGetCleanlyMapped() {
        Assertions.assertThat((int)this.props.getInstances().size()).isEqualTo(2);
        Assertions.assertThat((int)((List)this.props.getInstances().get("service1")).size()).isEqualTo(2);
        Assertions.assertThat((String)((SimpleDiscoveryProperties.SimpleServiceInstance)((List)this.props.getInstances().get("service1")).get(0)).getHost()).isEqualTo((Object)"s1-1");
        Assertions.assertThat((int)((SimpleDiscoveryProperties.SimpleServiceInstance)((List)this.props.getInstances().get("service1")).get(0)).getPort()).isEqualTo(8080);
        Assertions.assertThat((URI)((SimpleDiscoveryProperties.SimpleServiceInstance)((List)this.props.getInstances().get("service1")).get(0)).getUri()).isEqualTo((Object)URI.create("http://s1-1:8080"));
        Assertions.assertThat((boolean)((SimpleDiscoveryProperties.SimpleServiceInstance)((List)this.props.getInstances().get("service1")).get(0)).isSecure()).isEqualTo(false);
        Assertions.assertThat((int)((List)this.props.getInstances().get("service2")).size()).isEqualTo(2);
        Assertions.assertThat((String)((SimpleDiscoveryProperties.SimpleServiceInstance)((List)this.props.getInstances().get("service2")).get(0)).getHost()).isEqualTo((Object)"s2-1");
        Assertions.assertThat((int)((SimpleDiscoveryProperties.SimpleServiceInstance)((List)this.props.getInstances().get("service2")).get(0)).getPort()).isEqualTo(8080);
        Assertions.assertThat((URI)((SimpleDiscoveryProperties.SimpleServiceInstance)((List)this.props.getInstances().get("service2")).get(0)).getUri()).isEqualTo((Object)URI.create("https://s2-1:8080"));
        Assertions.assertThat((boolean)((SimpleDiscoveryProperties.SimpleServiceInstance)((List)this.props.getInstances().get("service2")).get(0)).isSecure()).isEqualTo(true);
    }

    @Test
    public void testDiscoveryClientShouldResolveSimpleValues() {
        Assertions.assertThat((String)this.discoveryClient.description()).isEqualTo((Object)"Simple Discovery Client");
        Assertions.assertThat((List)this.discoveryClient.getInstances("service1")).hasSize(2);
        ServiceInstance s1 = (ServiceInstance)this.discoveryClient.getInstances("service1").get(0);
        Assertions.assertThat((String)s1.getHost()).isEqualTo((Object)"s1-1");
        Assertions.assertThat((int)s1.getPort()).isEqualTo(8080);
        Assertions.assertThat((URI)s1.getUri()).isEqualTo((Object)URI.create("http://s1-1:8080"));
        Assertions.assertThat((boolean)s1.isSecure()).isEqualTo(false);
    }

    @Test
    public void testGetServices() {
        Assertions.assertThat((List)this.discoveryClient.getServices()).containsExactlyInAnyOrder((Object[])new String[]{"service1", "service2"});
    }

    @Test
    public void testGetANonExistentServiceShouldReturnAnEmptyList() {
        Assertions.assertThat((List)this.discoveryClient.getInstances("nonexistent")).isNotNull();
        Assertions.assertThat((List)this.discoveryClient.getInstances("nonexistent")).isEmpty();
    }

    @Test
    public void testGetLocalInstance() {
        Assertions.assertThat((String)this.discoveryClient.getLocalServiceInstance().getServiceId()).isEqualTo((Object)"service0");
        Assertions.assertThat((int)this.discoveryClient.getLocalServiceInstance().getPort()).isEqualTo(8080);
    }

    @Configuration
    @EnableAutoConfiguration
    public static class SampleConfig {
    }
}

