/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.cloud.client.loadbalancer.AbstractLoadBalancerAutoConfigurationTests;
import org.springframework.cloud.client.loadbalancer.LoadBalancedBackOffPolicyFactory;
import org.springframework.cloud.client.loadbalancer.RetryLoadBalancerInterceptor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.web.client.RestTemplate;

public class RetryLoadBalancerAutoConfigurationTests
extends AbstractLoadBalancerAutoConfigurationTests {
    @Override
    protected void assertLoadBalanced(RestTemplate restTemplate) {
        List interceptors = restTemplate.getInterceptors();
        MatcherAssert.assertThat((Object)interceptors, (Matcher)Matchers.hasSize((int)1));
        ClientHttpRequestInterceptor interceptor = (ClientHttpRequestInterceptor)interceptors.get(0);
        MatcherAssert.assertThat((Object)interceptor, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(RetryLoadBalancerInterceptor.class)));
    }

    @Test
    public void testDefaultBackOffPolicy() throws Exception {
        ConfigurableApplicationContext context = this.init(AbstractLoadBalancerAutoConfigurationTests.OneRestTemplate.class);
        LoadBalancedBackOffPolicyFactory loadBalancedBackOffPolicyFactory = (LoadBalancedBackOffPolicyFactory)context.getBean(LoadBalancedBackOffPolicyFactory.class);
        MatcherAssert.assertThat((Object)loadBalancedBackOffPolicyFactory, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(LoadBalancedBackOffPolicyFactory.NoBackOffPolicyFactory.class)));
        MatcherAssert.assertThat((Object)loadBalancedBackOffPolicyFactory.createBackOffPolicy("foo"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(NoBackOffPolicy.class)));
    }
}

