/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancedBackOffPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryListenerFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRetryProperties;
import org.springframework.cloud.client.loadbalancer.RetryLoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.TerminatedRetryException;
import org.springframework.retry.backoff.BackOffContext;
import org.springframework.retry.backoff.BackOffInterruptedException;
import org.springframework.retry.backoff.BackOffPolicy;

@RunWith(value=MockitoJUnitRunner.class)
public class RetryLoadBalancerInterceptorTest {
    private LoadBalancerClient client;
    private LoadBalancerRetryProperties lbProperties;
    private LoadBalancerRequestFactory lbRequestFactory;
    private LoadBalancedBackOffPolicyFactory backOffPolicyFactory = new LoadBalancedBackOffPolicyFactory.NoBackOffPolicyFactory();
    private LoadBalancedRetryListenerFactory retryListenerFactory = new LoadBalancedRetryListenerFactory.DefaultRetryListenerFactory();

    @Before
    public void setUp() throws Exception {
        this.client = (LoadBalancerClient)Mockito.mock(LoadBalancerClient.class);
        this.lbProperties = new LoadBalancerRetryProperties();
        this.lbRequestFactory = (LoadBalancerRequestFactory)Mockito.mock(LoadBalancerRequestFactory.class);
    }

    @After
    public void tearDown() throws Exception {
        this.client = null;
        this.lbProperties = null;
    }

    @Test(expected=IOException.class)
    public void interceptDisableRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)Matchers.eq((Object)"foo"), (ServiceInstanceChooser)Matchers.any(ServiceInstanceChooser.class))).thenReturn(null);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()});
        this.lbProperties.setEnabled(false);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory, this.backOffPolicyFactory, this.retryListenerFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, body, execution);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test(expected=IllegalStateException.class)
    public void interceptInvalidHost() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo_underscore"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)Matchers.eq((Object)"foo_underscore"), (ServiceInstanceChooser)Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo_underscore"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo_underscore"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponse);
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory, this.backOffPolicyFactory, this.retryListenerFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, body, execution);
    }

    @Test
    public void interceptNeverRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)Matchers.eq((Object)"foo"), (ServiceInstanceChooser)Matchers.any(ServiceInstanceChooser.class))).thenReturn(null);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponse);
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory, this.backOffPolicyFactory, this.retryListenerFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, body, execution);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test
    public void interceptSuccess() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)Matchers.eq((Object)"foo"), (ServiceInstanceChooser)Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponse);
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory, this.backOffPolicyFactory, this.retryListenerFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        MatcherAssert.assertThat((Object)rsp, (Matcher)org.hamcrest.Matchers.is((Object)clientHttpResponse));
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test
    public void interceptRetryOnStatusCode() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        InputStream notFoundStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)notFoundStream.read((byte[])Matchers.any(byte[].class))).thenReturn((Object)-1);
        MockClientHttpResponse clientHttpResponseNotFound = new MockClientHttpResponse(notFoundStream, HttpStatus.NOT_FOUND);
        MockClientHttpResponse clientHttpResponseOk = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.retryableStatusCode(Matchers.eq((int)HttpStatus.NOT_FOUND.value()))).thenReturn((Object)true);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)Matchers.eq((Object)"foo"), (ServiceInstanceChooser)Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponseNotFound).thenReturn((Object)clientHttpResponseOk);
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory, this.backOffPolicyFactory, this.retryListenerFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class));
        ((InputStream)Mockito.verify((Object)notFoundStream, (VerificationMode)Mockito.times((int)1))).close();
        MatcherAssert.assertThat((Object)rsp, (Matcher)org.hamcrest.Matchers.is((Object)clientHttpResponseOk));
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
    }

    @Test
    public void interceptRetryFailOnStatusCode() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        ByteArrayInputStream notFoundStream = new ByteArrayInputStream("foo".getBytes());
        MockClientHttpResponse clientHttpResponseNotFound = new MockClientHttpResponse((InputStream)notFoundStream, HttpStatus.NOT_FOUND);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.retryableStatusCode(Matchers.eq((int)HttpStatus.NOT_FOUND.value()))).thenReturn((Object)true);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)false);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)Matchers.eq((Object)"foo"), (ServiceInstanceChooser)Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponseNotFound);
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory, (LoadBalancedBackOffPolicyFactory)new LoadBalancedBackOffPolicyFactory.NoBackOffPolicyFactory(), (LoadBalancedRetryListenerFactory)new LoadBalancedRetryListenerFactory.DefaultRetryListenerFactory());
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class));
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)1))).createRequest(request, body, execution);
        ((LoadBalancedRetryPolicy)Mockito.verify((Object)policy, (VerificationMode)Mockito.times((int)2))).canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class));
        byte[] content = new byte[1024];
        int length = rsp.getBody().read(content);
        MatcherAssert.assertThat((Object)length, (Matcher)org.hamcrest.Matchers.is((Object)"foo".getBytes().length));
        MatcherAssert.assertThat((Object)new String(content, 0, length), (Matcher)org.hamcrest.Matchers.is((Object)"foo"));
    }

    @Test
    public void interceptRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)Matchers.eq((Object)"foo"), (ServiceInstanceChooser)Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        LoadBalancedBackOffPolicyFactory backOffPolicyFactory = (LoadBalancedBackOffPolicyFactory)Mockito.mock(LoadBalancedBackOffPolicyFactory.class);
        MyBackOffPolicy backOffPolicy = new MyBackOffPolicy();
        Mockito.when((Object)backOffPolicyFactory.createBackOffPolicy((String)Matchers.eq((Object)"foo"))).thenReturn((Object)backOffPolicy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory, backOffPolicyFactory, this.retryListenerFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class));
        MatcherAssert.assertThat((Object)rsp, (Matcher)org.hamcrest.Matchers.is((Object)clientHttpResponse));
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
        MatcherAssert.assertThat((Object)backOffPolicy.getBackoffAttempts(), (Matcher)org.hamcrest.Matchers.is((Object)1));
    }

    @Test(expected=IOException.class)
    public void interceptFailedRetry() throws Exception {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetrySameServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)false);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)false);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)Matchers.eq((Object)"foo"), (ServiceInstanceChooser)Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"foo"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory, this.backOffPolicyFactory, this.retryListenerFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, body, execution);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test
    public void retryListenerTest() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://listener"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)Matchers.eq((Object)"listener"), (ServiceInstanceChooser)Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        LoadBalancedBackOffPolicyFactory backOffPolicyFactory = (LoadBalancedBackOffPolicyFactory)Mockito.mock(LoadBalancedBackOffPolicyFactory.class);
        MyBackOffPolicy backOffPolicy = new MyBackOffPolicy();
        Mockito.when((Object)backOffPolicyFactory.createBackOffPolicy((String)Matchers.eq((Object)"listener"))).thenReturn((Object)backOffPolicy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"listener"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"listener"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        this.lbProperties.setEnabled(true);
        MyRetryListeners retryListeners = new MyRetryListeners();
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory, backOffPolicyFactory, (LoadBalancedRetryListenerFactory)retryListeners);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)Matchers.eq((Object)"listener"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class));
        MatcherAssert.assertThat((Object)rsp, (Matcher)org.hamcrest.Matchers.is((Object)clientHttpResponse));
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
        MatcherAssert.assertThat((Object)backOffPolicy.getBackoffAttempts(), (Matcher)org.hamcrest.Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)retryListeners.getOnError(), (Matcher)org.hamcrest.Matchers.is((Object)1));
    }

    @Test(expected=TerminatedRetryException.class)
    public void retryListenerTestNoRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://noRetry"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)Matchers.eq((Object)"noRetry"), (ServiceInstanceChooser)Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        LoadBalancedBackOffPolicyFactory backOffPolicyFactory = (LoadBalancedBackOffPolicyFactory)Mockito.mock(LoadBalancedBackOffPolicyFactory.class);
        MyBackOffPolicy backOffPolicy = new MyBackOffPolicy();
        Mockito.when((Object)backOffPolicyFactory.createBackOffPolicy((String)Matchers.eq((Object)"noRetry"))).thenReturn((Object)backOffPolicy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"noRetry"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"noRetry"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        this.lbProperties.setEnabled(true);
        MyRetryListenersNotRetry retryListeners = new MyRetryListenersNotRetry();
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory, backOffPolicyFactory, (LoadBalancedRetryListenerFactory)retryListeners);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, body, execution);
    }

    @Test
    public void retryWithDefaultConstructorTest() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://default"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)Matchers.eq((Object)"default"), (ServiceInstanceChooser)Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        LoadBalancedBackOffPolicyFactory backOffPolicyFactory = (LoadBalancedBackOffPolicyFactory)Mockito.mock(LoadBalancedBackOffPolicyFactory.class);
        MyBackOffPolicy backOffPolicy = new MyBackOffPolicy();
        Mockito.when((Object)backOffPolicyFactory.createBackOffPolicy((String)Matchers.eq((Object)"default"))).thenReturn((Object)backOffPolicy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)Matchers.eq((Object)"default"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)Matchers.eq((Object)"default"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory, backOffPolicyFactory, (LoadBalancedRetryListenerFactory)new LoadBalancedRetryListenerFactory.DefaultRetryListenerFactory());
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)Matchers.eq((Object)"default"), (ServiceInstance)Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)Matchers.any(LoadBalancerRequest.class));
        MatcherAssert.assertThat((Object)rsp, (Matcher)org.hamcrest.Matchers.is((Object)clientHttpResponse));
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
        MatcherAssert.assertThat((Object)backOffPolicy.getBackoffAttempts(), (Matcher)org.hamcrest.Matchers.is((Object)1));
    }

    class MyRetryListenersNotRetry
    implements LoadBalancedRetryListenerFactory {
        MyRetryListenersNotRetry() {
        }

        public RetryListener[] createRetryListeners(String service) {
            return new RetryListener[]{new RetryListener(){

                public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
                    return false;
                }

                public <T, E extends Throwable> void close(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
                }

                public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
                }
            }};
        }
    }

    class MyRetryListeners
    implements LoadBalancedRetryListenerFactory {
        private int onError = 0;

        MyRetryListeners() {
        }

        public RetryListener[] createRetryListeners(String service) {
            return new RetryListener[]{new RetryListener(){

                public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
                    return true;
                }

                public <T, E extends Throwable> void close(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
                }

                public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
                    MyRetryListeners.this.onError++;
                }
            }};
        }

        int getOnError() {
            return this.onError;
        }
    }

    class MyBackOffPolicy
    implements BackOffPolicy {
        private int backoffAttempts = 0;

        MyBackOffPolicy() {
        }

        public BackOffContext start(RetryContext retryContext) {
            return new BackOffContext(){

                protected Object clone() throws CloneNotSupportedException {
                    return super.clone();
                }
            };
        }

        public void backOff(BackOffContext backOffContext) throws BackOffInterruptedException {
            ++this.backoffAttempts;
        }

        int getBackoffAttempts() {
            return this.backoffAttempts;
        }
    }
}

