/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.serviceregistry;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={Config.class}, properties={"management.port=0", "spring.cloud.service-registry.auto-registration.register-management=false"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class AbstractAutoServiceRegistrationMgmtDisabledTests {
    @Autowired
    private TestAutoServiceRegistration autoRegistration;

    @Test
    public void portsWork() {
        Assertions.assertThat((boolean)this.autoRegistration.shouldRegisterManagement()).isFalse();
    }

    public static class TestAutoServiceRegistration
    extends AbstractAutoServiceRegistration<TestRegistration> {
        private int port = 0;

        public TestAutoServiceRegistration(AutoServiceRegistrationProperties properties) {
            super((ServiceRegistry)new TestServiceRegistry(), properties);
        }

        protected AtomicInteger getPort() {
            return super.getPort();
        }

        protected String getAppName() {
            return super.getAppName();
        }

        protected TestAutoServiceRegistration() {
            super((ServiceRegistry)new TestServiceRegistry());
        }

        protected int getConfiguredPort() {
            return this.port;
        }

        protected void setConfiguredPort(int port) {
            this.port = port;
        }

        protected TestRegistration getRegistration() {
            return new TestRegistration();
        }

        protected TestRegistration getManagementRegistration() {
            return null;
        }

        protected Object getConfiguration() {
            return null;
        }

        protected boolean isEnabled() {
            return true;
        }
    }

    public static class TestServiceRegistry
    implements ServiceRegistry<TestRegistration> {
        private boolean registered = false;
        private boolean deregistered = false;

        public void register(TestRegistration registration) {
            if (registration == null) {
                throw new NullPointerException();
            }
            if (!(registration instanceof TestMgmtRegistration)) {
                this.registered = true;
            }
        }

        public void deregister(TestRegistration registration) {
            if (registration == null) {
                throw new NullPointerException();
            }
            if (!(registration instanceof TestMgmtRegistration)) {
                this.deregistered = true;
            }
        }

        public void close() {
        }

        public void setStatus(TestRegistration registration, String status) {
        }

        public Object getStatus(TestRegistration registration) {
            return null;
        }

        boolean isRegistered() {
            return this.registered;
        }

        boolean isDeregistered() {
            return this.deregistered;
        }
    }

    public static class TestMgmtRegistration
    extends TestRegistration {
        @Override
        public String getServiceId() {
            return "testMgmtRegistration3";
        }
    }

    public static class TestRegistration
    implements Registration {
        public String getServiceId() {
            return "testRegistration3";
        }

        public String getHost() {
            return null;
        }

        public int getPort() {
            return 0;
        }

        public boolean isSecure() {
            return false;
        }

        public URI getUri() {
            return null;
        }

        public Map<String, String> getMetadata() {
            return null;
        }
    }

    @EnableAutoConfiguration
    @Configuration
    public static class Config {
        @Bean
        public TestAutoServiceRegistration testAutoServiceRegistration(AutoServiceRegistrationProperties properties) {
            return new TestAutoServiceRegistration(properties);
        }
    }
}

