/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.serviceregistry;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.LocalManagementPort;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.embedded.LocalServerPort;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={Config.class}, properties={"management.port=0"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class AbstractAutoServiceRegistrationTests {
    @Autowired
    private TestAutoServiceRegistration autoRegistration;
    @LocalServerPort
    private int port;
    @LocalManagementPort
    private int managementPort;

    @Test
    public void portsWork() {
        Assert.assertNotEquals((String)"Lifecycle port is zero", (long)0L, (long)this.autoRegistration.getPort().get());
        Assert.assertNotEquals((String)"Lifecycle port is management port", (long)this.managementPort, (long)this.autoRegistration.getPort().get());
        Assert.assertEquals((String)"Lifecycle port is wrong", (long)this.port, (long)this.autoRegistration.getPort().get());
        Assert.assertTrue((String)"Lifecycle not running", (boolean)this.autoRegistration.isRunning());
        Assert.assertThat((String)"ServiceRegistry is wrong type", (Object)this.autoRegistration.getServiceRegistry(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(TestServiceRegistry.class)));
        TestServiceRegistry serviceRegistry = (TestServiceRegistry)this.autoRegistration.getServiceRegistry();
        Assert.assertTrue((String)"Lifecycle not registered", (boolean)serviceRegistry.isRegistered());
        Assert.assertEquals((String)"Lifecycle appName is wrong", (Object)"application", (Object)this.autoRegistration.getAppName());
    }

    public static class TestAutoServiceRegistration
    extends AbstractAutoServiceRegistration<TestRegistration> {
        private int port = 0;

        public TestAutoServiceRegistration(AutoServiceRegistrationProperties properties) {
            super(null, properties);
        }

        protected AtomicInteger getPort() {
            return super.getPort();
        }

        protected String getAppName() {
            return super.getAppName();
        }

        protected TestAutoServiceRegistration() {
            super((ServiceRegistry)new TestServiceRegistry());
        }

        protected int getConfiguredPort() {
            return this.port;
        }

        protected void setConfiguredPort(int port) {
            this.port = port;
        }

        protected TestRegistration getRegistration() {
            return new TestRegistration();
        }

        protected TestRegistration getManagementRegistration() {
            return null;
        }

        protected Object getConfiguration() {
            return null;
        }

        protected boolean isEnabled() {
            return true;
        }
    }

    public static class TestServiceRegistry
    implements ServiceRegistry<TestRegistration> {
        private boolean registered = false;
        private boolean deregistered = false;

        public void register(TestRegistration registration) {
            if (registration == null) {
                throw new NullPointerException();
            }
            if (!(registration instanceof TestMgmtRegistration)) {
                this.registered = true;
            }
        }

        public void deregister(TestRegistration registration) {
            if (registration == null) {
                throw new NullPointerException();
            }
            if (!(registration instanceof TestMgmtRegistration)) {
                this.deregistered = true;
            }
        }

        public void close() {
        }

        public void setStatus(TestRegistration registration, String status) {
        }

        public Object getStatus(TestRegistration registration) {
            return null;
        }

        boolean isRegistered() {
            return this.registered;
        }

        boolean isDeregistered() {
            return this.deregistered;
        }
    }

    public static class TestMgmtRegistration
    extends TestRegistration {
        @Override
        public String getServiceId() {
            return "testMgmtRegistration2";
        }
    }

    public static class TestRegistration
    implements Registration {
        public String getServiceId() {
            return "testRegistration2";
        }

        public String getHost() {
            return null;
        }

        public int getPort() {
            return 0;
        }

        public boolean isSecure() {
            return false;
        }

        public URI getUri() {
            return null;
        }

        public Map<String, String> getMetadata() {
            return null;
        }
    }

    @EnableAutoConfiguration
    @Configuration
    public static class Config {
        @Bean
        public TestAutoServiceRegistration testAutoServiceRegistration() {
            return new TestAutoServiceRegistration();
        }
    }
}

