/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.serviceregistry.endpoint;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.EndpointWebMvcAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.ManagementServerPropertiesAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.web.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.client.serviceregistry.endpoint.ServiceRegistryEndpoint;
import org.springframework.cloud.client.serviceregistry.endpoint.ServiceRegistryEndpointTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={TestConfiguration.class})
public class ServiceRegistryEndpointNoRegistrationTests {
    @Autowired
    private WebApplicationContext context;
    private MockMvc mvc;

    @Before
    public void setUp() {
        this.mvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).build();
    }

    @Test
    public void testGet() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/service-registry/instance-status", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testPost() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/service-registry/instance-status", (Object[])new Object[0]).content("newstatus")).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Import(value={JacksonAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, EndpointWebMvcAutoConfiguration.class, WebMvcAutoConfiguration.class, ManagementServerPropertiesAutoConfiguration.class})
    @Configuration
    public static class TestConfiguration {
        @Bean
        ServiceRegistryEndpoint serviceRegistryEndpoint() {
            return new ServiceRegistryEndpoint(this.serviceRegistry());
        }

        @Bean
        ServiceRegistry serviceRegistry() {
            return new ServiceRegistryEndpointTests.TestServiceRegistry();
        }
    }
}

