/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientFactory;
import org.springframework.cloud.commons.httpclient.CustomApplication;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={CustomApplication.class}, properties={"spring.cloud.httpclient.ok.enabled: true"})
public class CustomHttpClientConfigurationTests {
    @Autowired
    ApacheHttpClientFactory httpClientFactory;
    @Autowired
    ApacheHttpClientConnectionManagerFactory connectionManagerFactory;
    @Autowired
    OkHttpClientFactory okHttpClientFactory;
    @Autowired
    OkHttpClientConnectionPoolFactory okHttpClientConnectionPoolFactory;

    @Test
    public void connManFactory() throws Exception {
        Assert.assertTrue((boolean)ApacheHttpClientConnectionManagerFactory.class.isInstance(this.connectionManagerFactory));
        Assert.assertTrue((boolean)CustomApplication.MyApacheHttpClientConnectionManagerFactory.class.isInstance(this.connectionManagerFactory));
    }

    @Test
    public void apacheHttpClientFactory() throws Exception {
        Assert.assertTrue((boolean)ApacheHttpClientFactory.class.isInstance(this.httpClientFactory));
        Assert.assertTrue((boolean)CustomApplication.MyApacheHttpClientFactory.class.isInstance(this.httpClientFactory));
    }

    @Test
    public void connectionPoolFactory() throws Exception {
        Assert.assertTrue((boolean)OkHttpClientConnectionPoolFactory.class.isInstance(this.okHttpClientConnectionPoolFactory));
        Assert.assertTrue((boolean)CustomApplication.MyOkHttpConnectionPoolFactory.class.isInstance(this.okHttpClientConnectionPoolFactory));
    }

    @Test
    public void okHttpClientFactory() throws Exception {
        Assert.assertTrue((boolean)OkHttpClientFactory.class.isInstance(this.okHttpClientFactory));
        Assert.assertTrue((boolean)CustomApplication.MyOkHttpClientFactory.class.isInstance(this.okHttpClientFactory));
    }
}

