/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientFactory;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientFactory;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientFactory;
import org.springframework.cloud.commons.httpclient.MyApplication;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={MyApplication.class}, properties={"spring.cloud.httpclient.ok.enabled: true"})
public class DefaultHttpClientConfigurationTests {
    @Autowired
    ApacheHttpClientFactory httpClientFactory;
    @Autowired
    ApacheHttpClientConnectionManagerFactory connectionManagerFactory;
    @Autowired
    OkHttpClientFactory okHttpClientFactory;
    @Autowired
    OkHttpClientConnectionPoolFactory okHttpClientConnectionPoolFactory;

    @Test
    public void connManFactory() throws Exception {
        Assert.assertTrue((boolean)ApacheHttpClientConnectionManagerFactory.class.isInstance(this.connectionManagerFactory));
        Assert.assertTrue((boolean)DefaultApacheHttpClientConnectionManagerFactory.class.isInstance(this.connectionManagerFactory));
    }

    @Test
    public void apacheHttpClientFactory() throws Exception {
        Assert.assertTrue((boolean)ApacheHttpClientFactory.class.isInstance(this.httpClientFactory));
        Assert.assertTrue((boolean)DefaultApacheHttpClientFactory.class.isInstance(this.httpClientFactory));
    }

    @Test
    public void connPoolFactory() throws Exception {
        Assert.assertTrue((boolean)OkHttpClientConnectionPoolFactory.class.isInstance(this.okHttpClientConnectionPoolFactory));
        Assert.assertTrue((boolean)DefaultOkHttpClientConnectionPoolFactory.class.isInstance(this.okHttpClientConnectionPoolFactory));
    }

    @Test
    public void setOkHttpClientFactory() throws Exception {
        Assert.assertTrue((boolean)OkHttpClientFactory.class.isInstance(this.okHttpClientFactory));
        Assert.assertTrue((boolean)DefaultOkHttpClientFactory.class.isInstance(this.okHttpClientFactory));
    }
}

