/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientConnectionPoolFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultOkHttpClientConnectionPoolFactoryTest {
    @Test
    public void create() throws Exception {
        DefaultOkHttpClientConnectionPoolFactory connectionPoolFactory = new DefaultOkHttpClientConnectionPoolFactory();
        ConnectionPool connectionPool = connectionPoolFactory.create(2, 3L, TimeUnit.MILLISECONDS);
        int idleConnections = (Integer)this.getField(connectionPool, "maxIdleConnections");
        long keepAliveDuration = (Long)this.getField(connectionPool, "keepAliveDurationNs");
        Assert.assertEquals((long)2L, (long)idleConnections);
        Assert.assertEquals((long)TimeUnit.MILLISECONDS.toNanos(3L), (long)keepAliveDuration);
    }

    protected <T> T getField(Object target, String name) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        Object value = ReflectionUtils.getField((Field)field, (Object)target);
        return (T)value;
    }
}

