/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import com.couchbase.client.java.CouchbaseCluster;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.couchbase.config.CouchbaseEnvironmentFactoryBean;
import org.springframework.data.couchbase.config.CouchbaseEnvironmentParser;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CouchbaseClusterParser
extends AbstractSingleBeanDefinitionParser {
    public static final String CLUSTER_NODE_TAG = "node";
    public static final String CLUSTER_ENVIRONMENT_TAG = "env";
    public static final String CLUSTER_ENVIRONMENT_REF = "env-ref";

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "couchbaseCluster";
    }

    protected Class getBeanClass(Element element) {
        return CouchbaseCluster.class;
    }

    protected void doParse(Element element, BeanDefinitionBuilder bean) {
        bean.setFactoryMethod("create");
        bean.setDestroyMethodName("disconnect");
        this.parseEnvironment(bean, element);
        List nodes = DomUtils.getChildElementsByTagName((Element)element, (String)CLUSTER_NODE_TAG);
        if (nodes != null && nodes.size() > 0) {
            ArrayList<String> bootstrapUrls = new ArrayList<String>(nodes.size());
            for (int i = 0; i < nodes.size(); ++i) {
                bootstrapUrls.add(((Element)nodes.get(i)).getTextContent());
            }
            bean.addConstructorArgValue(bootstrapUrls);
        }
    }

    protected boolean parseEnvironment(BeanDefinitionBuilder clusterBuilder, Element clusterElement) {
        Element envElement = DomUtils.getChildElementByTagName((Element)clusterElement, (String)CLUSTER_ENVIRONMENT_TAG);
        if (envElement != null && envElement.hasAttributes()) {
            this.injectEnvElement(clusterBuilder, envElement);
            return true;
        }
        String envRef = clusterElement.getAttribute(CLUSTER_ENVIRONMENT_REF);
        if (StringUtils.hasText((String)envRef)) {
            this.injectEnvReference(clusterBuilder, envRef);
            return true;
        }
        this.injectEnvReference(clusterBuilder, "couchbaseEnv");
        return false;
    }

    protected void injectEnvElement(BeanDefinitionBuilder clusterBuilder, Element envElement) {
        BeanDefinitionBuilder envDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(CouchbaseEnvironmentFactoryBean.class);
        new CouchbaseEnvironmentParser().doParse(envElement, envDefinitionBuilder);
        clusterBuilder.addConstructorArgValue((Object)envDefinitionBuilder.getBeanDefinition());
    }

    protected void injectEnvReference(BeanDefinitionBuilder clusterBuilder, String envRef) {
        clusterBuilder.addConstructorArgReference(envRef);
    }
}

