/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.BackpressureException;
import com.couchbase.client.core.BucketClosedException;
import com.couchbase.client.core.DocumentConcurrentlyModifiedException;
import com.couchbase.client.core.ReplicaNotConfiguredException;
import com.couchbase.client.core.RequestCancelledException;
import com.couchbase.client.core.ServiceNotAvailableException;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.endpoint.SSLException;
import com.couchbase.client.core.endpoint.kv.AuthenticationException;
import com.couchbase.client.core.env.EnvironmentException;
import com.couchbase.client.core.state.NotConnectedException;
import com.couchbase.client.java.error.BucketDoesNotExistException;
import com.couchbase.client.java.error.CASMismatchException;
import com.couchbase.client.java.error.DesignDocumentException;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import com.couchbase.client.java.error.DurabilityException;
import com.couchbase.client.java.error.InvalidPasswordException;
import com.couchbase.client.java.error.RequestTooBigException;
import com.couchbase.client.java.error.TemporaryFailureException;
import com.couchbase.client.java.error.TemporaryLockFailureException;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.error.ViewDoesNotExistException;
import java.util.concurrent.TimeoutException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.couchbase.core.OperationCancellationException;

public class CouchbaseExceptionTranslator
implements PersistenceExceptionTranslator {
    public final DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof InvalidPasswordException || ex instanceof NotConnectedException || ex instanceof ConfigurationException || ex instanceof EnvironmentException || ex instanceof InvalidPasswordException || ex instanceof SSLException || ex instanceof ServiceNotAvailableException || ex instanceof BucketClosedException || ex instanceof BucketDoesNotExistException || ex instanceof AuthenticationException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof DocumentAlreadyExistsException) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof DocumentDoesNotExistException) {
            return new DataRetrievalFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof CASMismatchException || ex instanceof DocumentConcurrentlyModifiedException || ex instanceof ReplicaNotConfiguredException || ex instanceof DurabilityException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof RequestCancelledException || ex instanceof BackpressureException) {
            return new OperationCancellationException(ex.getMessage(), ex);
        }
        if (ex instanceof ViewDoesNotExistException || ex instanceof RequestTooBigException || ex instanceof DesignDocumentException) {
            return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TemporaryLockFailureException || ex instanceof TemporaryFailureException) {
            return new TransientDataAccessResourceException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof RuntimeException && ex.getCause() instanceof TimeoutException) {
            return new QueryTimeoutException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TranscodingException) {
            return new DataRetrievalFailureException(ex.getMessage(), (Throwable)ex);
        }
        throw ex;
    }
}

