/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.ViewQuery;
import java.io.Serializable;
import org.reactivestreams.Publisher;
import org.springframework.data.couchbase.core.RxJavaCouchbaseOperations;
import org.springframework.data.couchbase.core.query.View;
import org.springframework.data.couchbase.repository.ReactiveCouchbaseRepository;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.ViewMetadataProvider;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.Single;

public class SimpleReactiveCouchbaseRepository<T, ID extends Serializable>
implements ReactiveCouchbaseRepository<T, ID> {
    private final RxJavaCouchbaseOperations operations;
    private final CouchbaseEntityInformation<T, String> entityInformation;
    private ViewMetadataProvider viewMetadataProvider;

    public SimpleReactiveCouchbaseRepository(CouchbaseEntityInformation<T, String> metadata, RxJavaCouchbaseOperations operations) {
        Assert.notNull((Object)operations, (String)"RxJavaCouchbaseOperations must not be null!");
        Assert.notNull(metadata, (String)"CouchbaseEntityInformation must not be null!");
        this.entityInformation = metadata;
        this.operations = operations;
    }

    public void setViewMetadataProvider(ViewMetadataProvider viewMetadataProvider) {
        this.viewMetadataProvider = viewMetadataProvider;
    }

    protected Mono mapMono(Single single) {
        return (Mono)ReactiveWrapperConverters.toWrapper((Object)single, Mono.class);
    }

    protected Flux mapFlux(Observable observable) {
        return (Flux)ReactiveWrapperConverters.toWrapper((Object)observable, Flux.class);
    }

    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.mapMono(this.operations.save(entity).toSingle());
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return this.mapFlux(this.operations.save(entities));
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"The given Iterable of entities must not be null!");
        return Flux.from(entityStream).flatMap(object -> this.save(object));
    }

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mapMono(this.operations.findById(id.toString(), this.entityInformation.getJavaType()).toSingle()).onErrorResume(throwable -> {
            if (throwable instanceof NullPointerException) {
                return Mono.empty();
            }
            return Mono.just((Object)throwable);
        });
    }

    public Mono<T> findById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given Publisher must not be null!");
        return Mono.from(publisher).flatMap(this::findById);
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mapMono(this.operations.exists(id.toString()).toSingle());
    }

    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given Publisher must not be null!");
        return Mono.from(publisher).flatMap(this::existsById);
    }

    public Flux<T> findAll() {
        ResolvedView resolvedView = this.determineView();
        ViewQuery query = ViewQuery.from((String)resolvedView.getDesignDocument(), (String)resolvedView.getViewName());
        query.reduce(false);
        query.stale(this.operations.getDefaultConsistency().viewConsistency());
        return this.mapFlux(this.operations.findByView(query, this.entityInformation.getJavaType()));
    }

    public Flux<T> findAllById(Iterable<ID> ids) {
        ResolvedView resolvedView = this.determineView();
        ViewQuery query = ViewQuery.from((String)resolvedView.getDesignDocument(), (String)resolvedView.getViewName());
        query.reduce(false);
        query.stale(this.operations.getDefaultConsistency().viewConsistency());
        JsonArray keys = JsonArray.create();
        for (Serializable id : ids) {
            keys.add((Object)id);
        }
        query.keys(keys);
        return this.mapFlux(this.operations.findByView(query, this.entityInformation.getJavaType()));
    }

    public Flux<T> findAllById(Publisher<ID> entityStream) {
        Assert.notNull(entityStream, (String)"The given entityStream must not be null!");
        return Flux.from(entityStream).flatMap(this::findById);
    }

    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.mapMono(this.operations.remove(id.toString()).map(res -> Observable.empty()).toSingle());
    }

    public Mono<Void> deleteById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given id must not be null!");
        return Mono.from(publisher).flatMap(this::deleteById);
    }

    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, (String)"The given id must not be null!");
        return this.mapMono(this.operations.remove(entity).map(res -> Observable.empty()).toSingle());
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return this.mapMono(this.operations.remove(entities).last().map(res -> Observable.empty()).toSingle());
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"The given publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(entity -> this.delete(entity)).single();
    }

    public Mono<Long> count() {
        ResolvedView resolvedView = this.determineView();
        ViewQuery query = ViewQuery.from((String)resolvedView.getDesignDocument(), (String)resolvedView.getViewName());
        query.reduce(true);
        query.stale(this.operations.getDefaultConsistency().viewConsistency());
        return this.mapMono(this.operations.queryView(query).flatMap(AsyncViewResult::rows).map(asyncViewRow -> Long.valueOf(asyncViewRow.value().toString())).switchIfEmpty(Observable.just((Object)0L)).toSingle());
    }

    public Mono<Void> deleteAll() {
        ResolvedView resolvedView = this.determineView();
        ViewQuery query = ViewQuery.from((String)resolvedView.getDesignDocument(), (String)resolvedView.getViewName());
        query.reduce(false);
        query.stale(this.operations.getDefaultConsistency().viewConsistency());
        return this.mapMono(this.operations.queryView(query).flatMap(AsyncViewResult::rows).flatMap(row -> this.operations.remove(row.id()).onErrorResumeNext(throwable -> {
            if (throwable instanceof DocumentDoesNotExistException) {
                return Observable.empty();
            }
            return Observable.error((Throwable)throwable);
        })).toList().map(list -> Observable.empty()).toSingle());
    }

    protected CouchbaseEntityInformation<T, String> getEntityInformation() {
        return this.entityInformation;
    }

    private ResolvedView determineView() {
        String designDocument = StringUtils.uncapitalize((String)this.entityInformation.getJavaType().getSimpleName());
        String viewName = "all";
        View view = this.viewMetadataProvider.getView();
        if (view != null) {
            designDocument = view.designDocument();
            viewName = view.viewName();
        }
        return new ResolvedView(designDocument, viewName);
    }

    @Override
    public RxJavaCouchbaseOperations getCouchbaseOperations() {
        return this.operations;
    }

    private final class ResolvedView {
        private final String designDocument;
        private final String viewName;

        public ResolvedView(String designDocument, String viewName) {
            this.designDocument = designDocument;
            this.viewName = viewName;
        }

        private String getDesignDocument() {
            return this.designDocument;
        }

        private String getViewName() {
            return this.viewName;
        }
    }
}

