/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import org.neo4j.ogm.metadata.MetaData;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.neo4j.mapping.DefaultNeo4jIsNewStrategy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;

public class Neo4jPersistentEntity<T>
extends BasicPersistentEntity<T, Neo4jPersistentProperty> {
    private final Lazy<IsNewStrategy> fallbackIsNewStrategy = Lazy.of(() -> DefaultNeo4jIsNewStrategy.basedOn(this, metaData));

    Neo4jPersistentEntity(TypeInformation<T> information, MetaData metaData) {
        super(information);
    }

    protected IsNewStrategy getFallbackIsNewStrategy() {
        return (IsNewStrategy)this.fallbackIsNewStrategy.get();
    }

    protected Neo4jPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(Neo4jPersistentProperty property) {
        Neo4jPersistentProperty existingIdProperty;
        if (!property.isIdProperty()) {
            return null;
        }
        Neo4jPersistentProperty preferredIdProperty = existingIdProperty = (Neo4jPersistentProperty)this.getIdProperty();
        if (existingIdProperty == null) {
            preferredIdProperty = property;
        } else {
            if (existingIdProperty.getPropertyType() == property.getPropertyType()) {
                throw new MappingException(String.format("Attempt to add id property %s but already have property %s registered as id. Check your mapping configuration!", property.getField(), existingIdProperty.getField()));
            }
            if (existingIdProperty.getPropertyType() == Neo4jPersistentProperty.PropertyType.INTERNAL_ID_PROPERTY && property.getPropertyType() == Neo4jPersistentProperty.PropertyType.ID_PROPERTY) {
                preferredIdProperty = property;
            }
        }
        return preferredIdProperty;
    }
}

