/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.mapperhelper;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityField;

public class FieldHelper {
    private static final IFieldHelper fieldHelper;

    public static List<EntityField> getFields(Class<?> entityClass) {
        return fieldHelper.getFields(entityClass);
    }

    public static List<EntityField> getProperties(Class<?> entityClass) {
        return fieldHelper.getProperties(entityClass);
    }

    public static List<EntityField> getAll(Class<?> entityClass) {
        List<EntityField> fields = fieldHelper.getFields(entityClass);
        List<EntityField> properties = fieldHelper.getProperties(entityClass);
        ArrayList<EntityField> all = new ArrayList<EntityField>();
        HashSet<EntityField> usedSet = new HashSet<EntityField>();
        for (EntityField field : fields) {
            for (EntityField property : properties) {
                if (usedSet.contains(property) || !field.getName().equals(property.getName())) continue;
                field.copyFromPropertyDescriptor(property);
                usedSet.add(property);
                break;
            }
            all.add(field);
        }
        for (EntityField property : properties) {
            if (usedSet.contains(property)) continue;
            all.add(property);
        }
        return all;
    }

    static {
        String version = System.getProperty("java.version");
        fieldHelper = version.contains("1.6.") || version.contains("1.7.") ? new Jdk6_7FieldHelper() : new Jdk8FieldHelper();
    }

    static class Jdk6_7FieldHelper
    implements IFieldHelper {
        Jdk6_7FieldHelper() {
        }

        @Override
        public List<EntityField> getFields(Class<?> entityClass) {
            ArrayList<EntityField> fieldList = new ArrayList<EntityField>();
            this._getFields(entityClass, fieldList, this._getGenericTypeMap(entityClass), null);
            return fieldList;
        }

        @Override
        public List<EntityField> getProperties(Class<?> entityClass) {
            PropertyDescriptor[] descriptors;
            BeanInfo beanInfo;
            Map<String, Class<?>> genericMap = this._getGenericTypeMap(entityClass);
            ArrayList<EntityField> entityFields = new ArrayList<EntityField>();
            try {
                beanInfo = Introspector.getBeanInfo(entityClass);
            }
            catch (IntrospectionException e) {
                throw new MapperException(e);
            }
            for (PropertyDescriptor desc : descriptors = beanInfo.getPropertyDescriptors()) {
                if (desc == null || "class".equals(desc.getName())) continue;
                EntityField entityField = new EntityField(null, desc);
                if (desc.getReadMethod() != null && desc.getReadMethod().getGenericReturnType() != null && desc.getReadMethod().getGenericReturnType() instanceof TypeVariable) {
                    entityField.setJavaType(genericMap.get(((TypeVariable)desc.getReadMethod().getGenericReturnType()).getName()));
                } else if (desc.getWriteMethod() != null && desc.getWriteMethod().getGenericParameterTypes() != null && desc.getWriteMethod().getGenericParameterTypes().length == 1 && desc.getWriteMethod().getGenericParameterTypes()[0] instanceof TypeVariable) {
                    entityField.setJavaType(genericMap.get(((TypeVariable)desc.getWriteMethod().getGenericParameterTypes()[0]).getName()));
                }
                entityFields.add(entityField);
            }
            return entityFields;
        }

        private void _getFields(Class<?> entityClass, List<EntityField> fieldList, Map<String, Class<?>> genericMap, Integer level) {
            if (fieldList == null) {
                throw new NullPointerException("fieldList\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (level == null) {
                level = 0;
            }
            if (entityClass == Object.class) {
                return;
            }
            Field[] fields = entityClass.getDeclaredFields();
            int index = 0;
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                EntityField entityField = new EntityField(field, null);
                if (field.getGenericType() != null && field.getGenericType() instanceof TypeVariable) {
                    if (genericMap == null || !genericMap.containsKey(((TypeVariable)field.getGenericType()).getName())) {
                        throw new MapperException(entityClass + "\u5b57\u6bb5" + field.getName() + "\u7684\u6cdb\u578b\u7c7b\u578b\u65e0\u6cd5\u83b7\u53d6!");
                    }
                    entityField.setJavaType(genericMap.get(((TypeVariable)field.getGenericType()).getName()));
                } else {
                    entityField.setJavaType(field.getType());
                }
                if (level != 0) {
                    fieldList.add(index, entityField);
                    ++index;
                    continue;
                }
                fieldList.add(entityField);
            }
            Class<?> superClass = entityClass.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class) && (superClass.isAnnotationPresent(Entity.class) || !Map.class.isAssignableFrom(superClass) && !Collection.class.isAssignableFrom(superClass))) {
                Integer n = level;
                Integer n2 = level = Integer.valueOf(level + 1);
                this._getFields(superClass, fieldList, genericMap, level);
            }
        }

        private Map<String, Class<?>> _getGenericTypeMap(Class<?> entityClass) {
            HashMap genericMap = new HashMap();
            if (entityClass == Object.class) {
                return genericMap;
            }
            Class<?> superClass = entityClass.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class) && (superClass.isAnnotationPresent(Entity.class) || !Map.class.isAssignableFrom(superClass) && !Collection.class.isAssignableFrom(superClass))) {
                if (entityClass.getGenericSuperclass() instanceof ParameterizedType) {
                    Type[] types = ((ParameterizedType)entityClass.getGenericSuperclass()).getActualTypeArguments();
                    TypeVariable<Class<?>>[] typeVariables = superClass.getTypeParameters();
                    if (typeVariables.length > 0) {
                        for (int i = 0; i < typeVariables.length; ++i) {
                            if (!(types[i] instanceof Class)) continue;
                            genericMap.put(typeVariables[i].getName(), (Class)types[i]);
                        }
                    }
                }
                genericMap.putAll(this._getGenericTypeMap(superClass));
            }
            return genericMap;
        }
    }

    static class Jdk8FieldHelper
    implements IFieldHelper {
        Jdk8FieldHelper() {
        }

        @Override
        public List<EntityField> getFields(Class<?> entityClass) {
            List<EntityField> fields = this._getFields(entityClass, null, null);
            List<EntityField> properties = this.getProperties(entityClass);
            HashSet usedSet = new HashSet();
            block0: for (EntityField field : fields) {
                for (EntityField property : properties) {
                    if (usedSet.contains(property) || !field.getName().equals(property.getName())) continue;
                    field.setJavaType(property.getJavaType());
                    continue block0;
                }
            }
            return fields;
        }

        private List<EntityField> _getFields(Class<?> entityClass, List<EntityField> fieldList, Integer level) {
            if (fieldList == null) {
                fieldList = new ArrayList<EntityField>();
            }
            if (level == null) {
                level = 0;
            }
            if (entityClass.equals(Object.class)) {
                return fieldList;
            }
            Field[] fields = entityClass.getDeclaredFields();
            int index = 0;
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                if (level != 0) {
                    fieldList.add(index, new EntityField(field, null));
                    ++index;
                    continue;
                }
                fieldList.add(new EntityField(field, null));
            }
            Class<?> superClass = entityClass.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class) && (superClass.isAnnotationPresent(Entity.class) || !Map.class.isAssignableFrom(superClass) && !Collection.class.isAssignableFrom(superClass))) {
                level = level + 1;
                return this._getFields(entityClass.getSuperclass(), fieldList, level);
            }
            return fieldList;
        }

        @Override
        public List<EntityField> getProperties(Class<?> entityClass) {
            PropertyDescriptor[] descriptors;
            ArrayList<EntityField> entityFields = new ArrayList<EntityField>();
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(entityClass);
            }
            catch (IntrospectionException e) {
                throw new MapperException(e);
            }
            for (PropertyDescriptor desc : descriptors = beanInfo.getPropertyDescriptors()) {
                if (desc.getName().equals("class")) continue;
                entityFields.add(new EntityField(null, desc));
            }
            return entityFields;
        }
    }

    static interface IFieldHelper {
        public List<EntityField> getFields(Class<?> var1);

        public List<EntityField> getProperties(Class<?> var1);
    }
}

