/*
 * Decompiled with CFR 0.152.
 */
package com.hydra.base.aop;

import com.hydra.base.annotations.ControllerLog;
import com.hydra.base.utils.IpUtil;
import com.hydra.base.utils.JsonUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
@Aspect
public class ControllerLogAspect {
    private static final Logger log = LoggerFactory.getLogger(ControllerLogAspect.class);

    @Around(value="execution(public * com.hydra..*Controller.*(..))")
    public Object doAroundAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        ControllerLog controllerLog = method.getAnnotation(ControllerLog.class);
        boolean enableLog = true;
        if (controllerLog != null) {
            enableLog = controllerLog.enable();
        }
        long start = System.nanoTime();
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        assert (sra != null);
        HttpServletRequest request = sra.getRequest();
        String url = request.getRequestURL().toString();
        String ip = IpUtil.getIp(request);
        String argsMessage = this.getArgsMessage(proceedingJoinPoint);
        Object result = null;
        Throwable ex = null;
        try {
            result = proceedingJoinPoint.proceed();
        }
        catch (Throwable e) {
            try {
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                long spendTime = (System.nanoTime() - start) / 1000000L;
                String resultMessage = ex != null ? ex.getMessage() : JsonUtil.toJsonString((Object)result);
                if (enableLog) {
                    log.info("\u8bf7\u6c42url: {}, \u7528\u6237IP: {}, \u8bf7\u6c42\u53c2\u6570: {}, \u54cd\u5e94:{}, \u8017\u65f6:{}ms", new Object[]{url, ip, argsMessage, resultMessage, spendTime});
                }
                throw throwable;
            }
        }
        long spendTime = (System.nanoTime() - start) / 1000000L;
        String resultMessage = ex != null ? ex.getMessage() : JsonUtil.toJsonString((Object)result);
        if (enableLog) {
            log.info("\u8bf7\u6c42url: {}, \u7528\u6237IP: {}, \u8bf7\u6c42\u53c2\u6570: {}, \u54cd\u5e94:{}, \u8017\u65f6:{}ms", new Object[]{url, ip, argsMessage, resultMessage, spendTime});
        }
        return result;
    }

    private String getArgsMessage(ProceedingJoinPoint proceedingJoinPoint) {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        Object[] args = proceedingJoinPoint.getArgs();
        Object[] result = new Object[args.length];
        String argsMessage = "\u65e0";
        try {
            if (args.length > 0) {
                Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                List<Class> requestAnnotations = Arrays.asList(RequestBody.class, PathVariable.class, RequestParam.class);
                for (int i = 0; i < args.length; ++i) {
                    Annotation[] annotationArr;
                    List collect;
                    result[i] = args[i];
                    if (args[i] == null || !(collect = Arrays.stream(annotationArr = parameterAnnotations[i]).filter(item -> requestAnnotations.contains(item.annotationType())).collect(Collectors.toList())).isEmpty()) continue;
                    result[i] = null;
                }
                argsMessage = JsonUtil.toJsonString((Object)result);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return argsMessage;
    }
}

