/*
 * Decompiled with CFR 0.152.
 */
package com.hydra.base.global;

import com.hydra.base.error.BusinessException;
import com.hydra.base.error.ValidateException;
import com.hydra.base.resp.ResultError;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={ValidateException.class})
    public ResultError handleValidateException(Exception e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.warn("handleValidateException start, uri:{}, exception:{}, caused by: {}", new Object[]{requestURI, e.getClass(), e.getMessage()});
        return ResultError.failure((int)400, (String)"Validate Error", (String)e.getMessage(), (String)requestURI);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={BusinessException.class})
    public ResultError handleBusinessException(Exception e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("handleBusinessException start, uri:{}, exception:{}, caused by: {}", new Object[]{requestURI, e.getClass(), e.getMessage()});
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            log.error("caused by: {}, location: {}", (Object)e.getMessage(), (Object)stackTrace[0].toString());
        }
        return ResultError.failure((int)500, (String)"Business Error", (String)e.getMessage(), (String)requestURI);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public ResultError handleException(Exception e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("handleException start, uri:{}, exception:{}, caused by: {}", new Object[]{requestURI, e.getClass(), e.getMessage(), e});
        return ResultError.failure((int)500, (String)"Internal Server Error", (String)e.getMessage(), (String)requestURI);
    }
}

