/*
 * Decompiled with CFR 0.152.
 */
package com.hydra.base.redis;

import com.alibaba.fastjson.JSONObject;
import com.hydra.base.utils.JsonUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisPlugin {
    private static final Logger log = LoggerFactory.getLogger(RedisPlugin.class);
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    public Object get(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public <T> T get(String key, Class<T> clazz) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof JSONObject) {
            return (T)((JSONObject)value).toJavaObject(clazz);
        }
        if (value instanceof String) {
            return (T)JsonUtil.parseObject((String)((String)value), clazz);
        }
        throw new RuntimeException("\u5904\u7406redis\u8fd4\u56dejson\u683c\u5f0f\u5f02\u5e38\uff1a" + value);
    }

    public Set<String> keys(String pattern) {
        if (pattern.startsWith("*")) {
            log.warn("\u7981\u6b62\u524d\u5339\u914d");
            return new HashSet<String>();
        }
        return this.redisTemplate.keys((Object)pattern);
    }

    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public void set(String key, Object value, long seconds) {
        this.redisTemplate.opsForValue().set((Object)key, value, seconds, TimeUnit.SECONDS);
    }

    public void set(byte[] key, byte[] value) {
        this.redisTemplate.execute(con -> {
            con.set(key, value);
            return null;
        });
    }

    public void setEx(String key, int seconds, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value, (long)seconds, TimeUnit.SECONDS);
    }

    public void setEx(byte[] key, int seconds, byte[] value) {
        this.redisTemplate.execute(con -> {
            con.setEx(key, (long)seconds, value);
            return null;
        });
    }

    public void setObject(String key, Object value) {
        this.setObject(key, value, -1L);
    }

    public void setObject(String key, Object value, long seconds) {
        String jsonString = JsonUtil.toJsonString((Object)value);
        this.redisTemplate.opsForValue().set((Object)key, (Object)jsonString, seconds, TimeUnit.SECONDS);
    }

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public void deleteKey(String ... keys) {
        this.redisTemplate.delete(Arrays.asList(keys));
    }

    public void expire(String key, long time) {
        this.redisTemplate.expire((Object)key, time, TimeUnit.MINUTES);
    }

    public long getExpire(String key) {
        Long expire = this.redisTemplate.getExpire((Object)key);
        return expire == null ? 0L : expire;
    }

    public boolean hasKey(String key) {
        Boolean exist = this.redisTemplate.hasKey((Object)key);
        return exist != null && exist != false;
    }
}

