/*
 * Decompiled with CFR 0.152.
 */
package com.hydra.base.redis;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

@Configuration
@Component
public class RedisService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private TransmittableThreadLocal<String> lockFlag = new TransmittableThreadLocal();
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private ValueOperations<String, String> valueOps;
    private ListOperations<String, String> listOps;
    private HashOperations<String, String, String> hashOps;
    private SetOperations<String, String> setOps;
    private ZSetOperations<String, String> zSetOps;
    private GeoOperations<String, String> geoOps;

    @PostConstruct
    public void init() {
        this.valueOps = this.redisTemplate.opsForValue();
        this.listOps = this.redisTemplate.opsForList();
        this.hashOps = this.redisTemplate.opsForHash();
        this.setOps = this.redisTemplate.opsForSet();
        this.zSetOps = this.redisTemplate.opsForZSet();
        this.geoOps = this.redisTemplate.opsForGeo();
    }

    public String get(String key) {
        return (String)this.valueOps.get((Object)key);
    }

    public Long getAsLong(String key) {
        String value = (String)this.valueOps.get((Object)key);
        return value == null ? null : (Long)NumberUtils.parseNumber((String)value, Long.class);
    }

    public List<String> multiGet(Collection<String> keys) {
        return this.valueOps.multiGet(keys);
    }

    public void set(String key, String value) {
        this.valueOps.set((Object)key, (Object)value);
    }

    public Boolean setNx(String key, String value) {
        return this.valueOps.setIfAbsent((Object)key, (Object)value);
    }

    public void set(String key, String value, long timeout, TimeUnit timeUnit) {
        this.valueOps.set((Object)key, (Object)value, timeout, timeUnit);
    }

    public Boolean setIfAbsent(String key, String value) {
        return this.valueOps.setIfAbsent((Object)key, (Object)value);
    }

    public Boolean setIfAbsent(String key, String value, long timeout, TimeUnit timeUnit) {
        return this.valueOps.setIfAbsent((Object)key, (Object)value, timeout, timeUnit);
    }

    public void multiSet(Map<String, String> keyValueMap) {
        if (keyValueMap == null || keyValueMap.size() <= 0) {
            return;
        }
        this.valueOps.multiSet(keyValueMap);
    }

    public void multiSetIfAbsent(Map<String, String> keyValueMap) {
        if (keyValueMap == null || keyValueMap.size() <= 0) {
            return;
        }
        this.valueOps.multiSetIfAbsent(keyValueMap);
    }

    public String getAndSet(String key, String value) {
        return (String)this.valueOps.getAndSet((Object)key, (Object)value);
    }

    public Long incr(String key) {
        return this.valueOps.increment((Object)key, 1L);
    }

    public Long incrBy(String key, long increment) {
        return this.valueOps.increment((Object)key, increment);
    }

    public Long decr(String key) {
        return this.valueOps.decrement((Object)key);
    }

    public Long decr(String key, long decrement) {
        return this.valueOps.decrement((Object)key, decrement);
    }

    public void lpush(String key, String value) {
        this.listOps.leftPush((Object)key, (Object)value);
    }

    public String lpop(String key) {
        return (String)this.listOps.leftPop((Object)key);
    }

    public void lpushAll(String key, String ... values) {
        this.listOps.leftPushAll((Object)key, (Object[])values);
    }

    public void rpush(String key, String value) {
        this.listOps.rightPush((Object)key, (Object)value);
    }

    public String rpop(String key) {
        return (String)this.listOps.rightPop((Object)key);
    }

    public void rpushAll(String key, String ... values) {
        this.listOps.rightPushAll((Object)key, (Object[])values);
    }

    public void clearList(String key) {
        this.listOps.trim((Object)key, 1L, 0L);
    }

    public void lDeleteElem(String key, String value) {
        this.listOps.remove((Object)key, 0L, (Object)value);
    }

    public List<String> getListAllItems(String key) {
        return this.listOps.range((Object)key, 0L, -1L);
    }

    public Long llen(String key) {
        return this.listOps.size((Object)key);
    }

    public String hget(String key, String hashKey) {
        return (String)this.hashOps.get((Object)key, (Object)hashKey);
    }

    public Long hgetAsLong(String key, String hashKey) {
        String hashValue = (String)this.hashOps.get((Object)key, (Object)hashKey);
        return hashValue == null ? null : (Long)NumberUtils.parseNumber((String)hashValue, Long.class);
    }

    public void hset(String key, String hashKey, String hashValue) {
        this.hashOps.put((Object)key, (Object)hashKey, (Object)hashValue);
    }

    public void hsetAll(String key, Map<String, String> map) {
        this.hashOps.putAll((Object)key, map);
    }

    public Map<String, String> hgetAll(String key) {
        return this.hashOps.entries((Object)key);
    }

    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public void deleteKey(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public void deleteKeys(String ... keys) {
        this.deleteKeys(Arrays.asList(keys));
    }

    public void deleteKeys(Collection<String> keys) {
        this.redisTemplate.delete(keys);
    }

    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public void expire(String key, long timeout, TimeUnit timeUnit) {
        this.redisTemplate.expire((Object)key, timeout, timeUnit);
    }

    public void expireAt(String key, Date date) {
        this.redisTemplate.expireAt((Object)key, date);
    }

    public void expireAt(String key, long expireAt) {
        this.expireAt(key, new Date(expireAt));
    }

    public <T> T execute(RedisScript<T> redisScript, List<String> keys, Object ... args) {
        return (T)this.redisTemplate.execute(redisScript, keys, args);
    }

    public <T> T executeInRedis(RedisCallback<T> redisCallback) {
        return (T)this.redisTemplate.execute(redisCallback);
    }

    public boolean tryLock(String basePrefix) {
        return this.tryLock(basePrefix, 0L, null);
    }

    private boolean setRedisNXPX(String key, long expire) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        this.lockFlag.set((Object)uuid);
        try {
            boolean result = this.valueOps.setIfAbsent((Object)key, (Object)uuid, expire, TimeUnit.MILLISECONDS);
            this.logger.info("lock key {} [{}] : ", (Object)key, (Object)result);
            return result;
        }
        catch (Exception e) {
            this.logger.error("set redis occured an exception", (Throwable)e);
            return false;
        }
    }

    public boolean lockByNXPX(String key, long expire) {
        return this.lockByNXPX(key, expire, 0, 0L);
    }

    public boolean lockByNXPX(String key, long expire, int retryTimes, long sleepMillis) {
        boolean result = this.setRedisNXPX(key, expire);
        while (!Thread.currentThread().isInterrupted() && !result && retryTimes-- > 0) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.error("\u83b7\u53d6Redis\u9501\u5931\u8d25\uff0c\u5c06\u7ebf\u7a0b\u6302\u8d77\u3002key: {} - expire: {} - retryTimes: {} - sleepMillis: {}", new Object[]{key, expire, retryTimes, sleepMillis});
                return false;
            }
            result = this.setRedisNXPX(key, expire);
        }
        return result;
    }

    public boolean releaseLockByNXPX(String key) {
        try {
            String val = this.get(key);
            if (!StringUtils.isEmpty((Object)val) && val.equals(this.lockFlag.get())) {
                this.deleteKey(key);
                this.logger.info("release lock \uff1a{} [{}]", (Object)key);
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("release lock occured an exception", (Throwable)e);
            return false;
        }
    }

    public boolean tryLock(String basePrefix, long timeout, TimeUnit unit) {
        return this.tryLock(basePrefix, timeout, unit, timeout, unit);
    }

    public boolean tryLock(String basePrefix, long lockTime, TimeUnit lockUnit, long waitTime, TimeUnit waitUnit) {
        String key = basePrefix;
        try {
            long nano = System.nanoTime();
            do {
                this.logger.debug("try lock key: " + key);
                boolean result = this.valueOps.setIfAbsent((Object)key, (Object)key, lockTime, lockUnit);
                if (result) {
                    this.logger.debug("get lock, key: " + key + " , expire in " + basePrefix + " seconds.");
                    return Boolean.TRUE;
                }
                if (this.logger.isDebugEnabled()) {
                    String desc = this.get(key);
                    this.logger.debug("key: " + key + " locked by another business\uff1a" + desc);
                }
                if (waitTime == 0L) break;
                Thread.sleep(300L);
            } while (System.nanoTime() - nano < waitUnit.toNanos(waitTime));
            return Boolean.FALSE;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Boolean.FALSE;
        }
    }

    public void lock(String key) {
        this.lock(key, 30L);
    }

    public void lock(String basePrefix, long seconds) {
        String key = basePrefix;
        try {
            while (true) {
                this.logger.debug("lock key: " + key);
                boolean result = this.valueOps.setIfAbsent((Object)key, (Object)key, seconds, TimeUnit.SECONDS);
                if (result) {
                    this.logger.debug("get lock, key: " + key + " , expire in " + seconds + " seconds.");
                    return;
                }
                if (this.logger.isDebugEnabled()) {
                    String desc = this.get(key);
                    this.logger.debug("key: " + key + " locked by another business\uff1a" + desc);
                }
                Thread.sleep(300L);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return;
        }
    }

    public void unLock(String basePrefix) {
        this.deleteKey(basePrefix);
    }

    public void unLock(List<String> billIdentifyList) {
        try {
            this.deleteKeys(billIdentifyList);
            this.logger.debug("release lock, keys :{}", billIdentifyList);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void multi() {
        this.redisTemplate.multi();
    }

    public void exec() {
        this.redisTemplate.exec();
    }

    public Long geoAdd(String key, Point p, String m) {
        return this.geoOps.add((Object)key, p, (Object)m);
    }

    public Long geoAdd(String key, RedisGeoCommands.GeoLocation<String> var2) {
        return this.geoOps.add((Object)key, var2);
    }

    public Long geoAdd(String key, Map<String, Point> points) {
        return this.geoOps.add((Object)key, points);
    }

    public Long geoAdd(String key, Iterable<RedisGeoCommands.GeoLocation<String>> locations) {
        return this.geoOps.add((Object)key, locations);
    }

    public Distance geoDistance(String key, String m1, String m2) {
        return this.geoOps.distance((Object)key, (Object)m1, (Object)m2);
    }

    public Distance geoDistance(String key, String m1, String m2, Metric metric) {
        return this.geoOps.distance((Object)key, (Object)m1, (Object)m2, metric);
    }

    public List<String> geoHash(String key, String ... ms) {
        return this.geoOps.hash((Object)key, (Object[])ms);
    }

    public List<Point> geoPosition(String key, String ... ms) {
        return this.geoOps.position((Object)key, (Object[])ms);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadius(String key, Circle circle) {
        return this.geoOps.radius((Object)key, circle);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadius(String key, Circle circle, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.geoOps.radius((Object)key, circle, args);
    }

    public Long geoRemove(String key, String ... ms) {
        return this.geoOps.remove((Object)key, (Object[])ms);
    }
}

