/*
 * Decompiled with CFR 0.152.
 */
package com.hydra.base.utils;

import com.hydra.base.utils.FormatUtil;
import com.hydra.base.utils.StringUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;

public class BeanConvertUtils
extends BeanUtils {
    public static void copyMapToBean(Map<String, Object> source, Object target) {
        BeanConvertUtils.copyMapToBean(source, target, null);
    }

    public static void copyMapToBeanConvertKey(Map<String, Object> source, Object target) {
        BeanConvertUtils.copyMapToBean(source, target, StringUtil::underLineToCamel);
    }

    public static void copyMapToBean(Map<String, Object> source, Object target, KeyConvertor convertor) {
        if (source == null || target == null) {
            return;
        }
        Class<?> targetClass = target.getClass();
        Set<String> keySet = source.keySet();
        for (String key : keySet) {
            PropertyDescriptor targetPd;
            Object value = source.get(key);
            if (convertor != null) {
                key = convertor.convertKey(key);
            }
            if ((targetPd = BeanConvertUtils.getPropertyDescriptor(targetClass, (String)key)) == null || targetPd.getReadMethod() == null) continue;
            try {
                if (value == null) continue;
                Class<?> propertyType = targetPd.getPropertyType();
                value = FormatUtil.formatValueByType((Object)value, propertyType);
                Method writeMethod = targetPd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Exception ex) {
                throw new FatalBeanException("Could not copy properties from source to target", (Throwable)ex);
            }
        }
    }

    public static void copyPropertiesWithoutNull(Object source, Object target) {
        PropertyDescriptor[] targetPds;
        if (source == null || target == null) {
            return;
        }
        Class<?> tClass = target.getClass();
        Class<?> sourceClass = source.getClass();
        for (PropertyDescriptor targetPd : targetPds = BeanConvertUtils.getPropertyDescriptors(tClass)) {
            PropertyDescriptor sourcePd;
            if (targetPd.getWriteMethod() == null || (sourcePd = BeanConvertUtils.getPropertyDescriptor(sourceClass, (String)targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            try {
                Object value;
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((value = readMethod.invoke(source, new Object[0])) == null) continue;
                Method writeMethod = targetPd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Exception ex) {
                throw new FatalBeanException("Could not copy properties from source to target", (Throwable)ex);
            }
        }
    }

    public static <S, T> T convertTo(S source, Supplier<T> targetSupplier, ConvertCallBack<S, T> callBack) {
        if (null == source || null == targetSupplier) {
            return null;
        }
        T target = targetSupplier.get();
        BeanConvertUtils.copyProperties(source, target);
        if (callBack != null) {
            callBack.callBack(source, target);
        }
        return target;
    }

    public static <S, T> List<T> convertListTo(List<S> sources, Supplier<T> targetSupplier) {
        return BeanConvertUtils.convertListTo(sources, targetSupplier, null);
    }

    public static <S, T> List<T> convertListTo(List<S> sources, Supplier<T> targetSupplier, ConvertCallBack<S, T> callBack) {
        if (null == sources || null == targetSupplier) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(sources.size());
        for (S source : sources) {
            T target = targetSupplier.get();
            BeanConvertUtils.copyProperties(source, target);
            if (callBack != null) {
                callBack.callBack(source, target);
            }
            list.add(target);
        }
        return list;
    }

    @FunctionalInterface
    public static interface KeyConvertor {
        public String convertKey(String var1);
    }

    @FunctionalInterface
    public static interface ConvertCallBack<S, T> {
        public void callBack(S var1, T var2);
    }
}

