/*
 * Decompiled with CFR 0.152.
 */
package com.hydra.base.utils;

import com.hydra.base.error.BusinessException;
import com.hydra.base.utils.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import reactor.util.annotation.NonNull;

@Component
public class SpringUtils
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringUtils.class);
    protected static ApplicationContext CONTEXT;

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        CONTEXT = applicationContext;
    }

    public static String getPlatform() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String platform = request.getHeader("platform");
        if (StringUtil.isBlank((CharSequence)platform)) {
            platform = "Web";
        }
        return platform;
    }

    public static String getSystemCode() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String systemCode = request.getHeader("systemCode");
        if (StringUtil.isBlank((CharSequence)systemCode)) {
            systemCode = "default";
        }
        return systemCode;
    }

    public static Object getBean(String name) throws BeansException {
        if (null == CONTEXT) {
            throw new BusinessException("The application context is null, please check.");
        }
        return CONTEXT.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) throws BeansException {
        if (null == CONTEXT) {
            throw new BusinessException("The application context is null, please check.");
        }
        return (T)CONTEXT.getBean(requiredType);
    }

    public static <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        if (null == CONTEXT) {
            throw new BusinessException("The application context is null, please check.");
        }
        return (T)CONTEXT.getBean(name, requiredType);
    }
}

