package com.roco.settle.api.entity;

import java.time.LocalDateTime;

import com.roco.settle.api.enums.SettlePaymentApplyLogOperTypeEnum;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 业务主体支付工单日志(SettlePaymentApplyLog)实体类
 *
 * @author hsf
 * @since 2020-02-29 08:25:11
 */
@Data
@Table(name = "settle_payment_apply_log")
public class SettlePaymentApplyLog implements Serializable {

   
    @Id
    private Long id;

    /**
     * settle_payment_apply.apply_no  
     */
    private String applyNo;

    /**
     * 操作类型  
     */
    private SettlePaymentApplyLogOperTypeEnum operType;

    /**
     * 备注  
     */
    private String remark;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String createUser;

    private String createName;

   

}