package com.roco.settle.api.entity.enterprisesettle;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.roco.settle.api.entity.SettleEnterpriseServiceApplyItem;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/** 业务基点->油卡结算申请单Item
 * @author zhangmin
 * @date 2020/2/29
 */
@Setter
@Getter
@Table(name = "settle_enterprise_oilcard_apply_item")
@JsonIgnoreProperties(ignoreUnknown = true)
public class SettleEnterpriseOilCardApplyItem implements Serializable {

    @Id
    private Long id;

    /**
     * 申请单号
     * {@link SettleEnterpriseOilCardApply#applyNo}
     */
    private String applyNo;

    /**
     * 服务清单明细编号
     * {@link SettleEnterpriseServiceApplyItem#detailNo}
     */
    private String serviceItemNo;

    /**
     * 备注
     */
    private String remark;

}
