package com.roco.settle.api.entity.order.payment;

import java.time.LocalDateTime;

import com.roco.settle.api.enums.SettlePaymentApplyLogOperTypeEnum;
import com.roco.settle.api.enums.order.payment.PaymentOrderOperationTypeEnum;
import com.roco.settle.api.request.base.FileRes;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.NoArgsConstructor;


/**
 * 供应商支付订单文件(SupplierPaymentApplyFile)实体类
 *
 * @author dongjuntong
 * @since 2020-02-27 19:45:57
 */
@Data
@Table(name = "supplier_payment_apply_file")
@NoArgsConstructor
public class SupplierPaymentApplyFile implements Serializable {



    public SupplierPaymentApplyFile(String orderNo,PaymentOrderOperationTypeEnum operType,String createUser,
                                  String createName, FileRes fileRes,String transferDetailCode) {
        this.orderNo = orderNo;
        this.fileName = fileRes.getFileName();
        this.fileType = fileRes.getFileType();
        this.fileurl = fileRes.getFileUrl();
        this.remark = fileRes.getRemark();
        this.transferDetailCode=transferDetailCode;
        this.operType = operType;
        this.createUser = createUser;
        this.createName = createName;
        this.createTime = LocalDateTime.now();
    }




    @Id
    private Long id;

    /**
     * 订单号  
     */
    private String orderNo;

    /**
     * 文件类型(PDF,PNG,JPG,JPEG)  
     */
    private String fileType;

    /**
     * 路径url  
     */
    private String fileurl;

    /**
     * 附件名称  
     */
    private String fileName;

    /**
     * 附件说明  
     */
    private String remark;

    /**
     * 操作类型  
     */
    private PaymentOrderOperationTypeEnum operType;

    /**
     * 上传时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人  
     */
    private String createUser;

    /**
     * 创建人姓名  
     */
    private String createName;

    /**
     * 关联的支付清单编号
     */
    private  String   transferDetailCode;

}